-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local tag = 'dump_door_latch'

local function onInit()
    electrics.values.doorL = 0
    electrics.values.dump_door_latch = 1
end

local function updateGFX(dt)
    if electrics.values.doorL == 0 and electrics.values.dump_door_latch == 0 then
        beamstate.attachCouplers(tag)
    elseif electrics.values.doorL == 1 and electrics.values.dump_door_latch == 1 then
        beamstate.detachCouplers(tag)
    end
end

local function onCouplerAttached(nodeId, obj2id, obj2nodeId)
    if v.data.nodes[nodeId].tag == "dump_door_latch" then
        electrics.values.dump_door_latch = 1
    end
end

local function onCouplerDetached(nodeId, obj2id, obj2nodeId)
    if v.data.nodes[nodeId].tag == "dump_door_latch" then
        electrics.values.dump_door_latch = 0
    end
end

-- public interface
M.onCouplerAttached = onCouplerAttached
M.onCouplerDetached = onCouplerDetached

M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M
