local M = {}
local activeSliders = {}

local function startSlider(electric, rate, cap)
	activeSliders[electric] = {rate = rate, cap = cap}
end

local function stopSlider(electric)
	activeSliders[electric] = nil
end

local function sign(value)
	if value == 0 then return 0 end
	if value > 0 then return 1 end
	return -1
end

local function onInit()
	electrics.values['interior_lights'] = 0
	electrics.values['interior_lights2'] = 0
	electrics.values['interior_lights3'] = 0
	electrics.values['toggle_car_carrier_ramp'] = 0
end

local function onReset()
	electrics.values['interior_lights'] = 0
	electrics.values['interior_lights2'] = 0
	electrics.values['interior_lights3'] = 0
	electrics.values['toggle_car_carrier_ramp'] = 0
end

local function updateGFX(dt)
	for electric,sliderData in pairs(activeSliders) do
		if sliderData ~= nil then
			local rsign = sign(sliderData.rate)
			if rsign ~= 0 then
				local cval = electrics.values[electric]
				cval = electrics.values[electric] + (sliderData.rate * dt)
				if rsign > 0 then cval = math.min(cval, sliderData.cap) else cval = math.max(cval, sliderData.cap) end
				electrics.values[electric] = cval
			end
		end
	end
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

M.startSlider = startSlider
M.stopSlider = stopSlider

return M
