


local M = {}

-- factor of speed
local moveSpeed = 10
local value = 0

local function lerp(a,b,t) 
    return a * (1-t) + b * t 
end

local function moveTowards(current, target, maxDelta)
  if target == current then return current end
  if math.abs(target - current) <= maxDelta then return target end
  if target < current then return current - maxDelta end
  if target > current then return current + maxDelta end
end


local function onInit()
  electrics.values["gearIndexSmoothed"] = value
end

local function onReset()
end

local function updateGFX(dt)
    local target = electrics.values.gearIndex or 0
    --value = lerp(value, target, dt * (1/smoothTime))
    value = moveTowards(value, target, moveSpeed * dt)
    electrics.values["gearIndexSmoothed"] = value
end

-- public interface
M.onInit      = onInit
M.onReset     = onReset
M.updateGFX = updateGFX

return M