local M = {}

local engine = nil
local rpmToAV = 0.104719755
local originalIdleAV = 500 * rpmToAV
local highIdleRPM = 1200

local function onInit()
    engine = powertrain.getDevice("mainEngine")
    if engine ~= nil then 
      originalIdleAV = engine.idleAV
    end
end

local function onReset()

end

local function updateGFX(dt)
  local highIdle = electrics.values["highIdle"] or 0
  local gear = electrics.values["gearIndex"] or 0
  if engine ~= nil then
    if highIdle < 0.5 or gear ~= 0 then
        engine.idleAV = originalIdleAV
    else
        engine.idleAV = highIdleRPM * rpmToAV
    end
  end
end

-- public interface
M.onInit      = onInit
M.onReset     = onReset
M.updateGFX = updateGFX

return M