local M = {}

local function onInit()
	electrics.values['interior_lights'] = 0
  electrics.values['interior_lights_lh'] = 0
  electrics.values['interior_lights_rh'] = 0
  electrics.values['interior_lights_driver'] = 0
  electrics.values['interior_lights_rear'] = 0
	electrics.values['strobelight_toggle'] = 0
	electrics.values['highIdle'] = 0
	electrics.values['jatoInput'] = 0
	electrics.values['airhorn'] = 0
  electrics.values['a3_headlight_switch'] = 0
  
  -- since props default to their max value instead of 0 :|
  electrics.values["fan_left_mode"] = 0
  electrics.values["fan_center_mode"] = 0
end

local function onReset()
	electrics.values['interior_lights'] = 0
  electrics.values['interior_lights_lh'] = 0
  electrics.values['interior_lights_rh'] = 0
  electrics.values['interior_lights_driver'] = 0
  electrics.values['interior_lights_rear'] = 0
	electrics.values['highIdle'] = 0
	electrics.values['jatoInput'] = 0
	electrics.values['airhorn'] = 0
end

local function updateGFX(dt)
  -- will produce 1 if  highbeam is on, or -1 if lowbeam is on, or 0 if none
  local lowbeam = electrics.values['lowbeam'] or 0
  local highbeam = electrics.values['highbeam'] or 0
  electrics.values['a3_headlight_switch'] = highbeam - lowbeam
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M
