-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

-- the strobe light works in phases. first off, then on, etc.
local totalPhaseTime = 0
local strobePhaseOffTime = 0
local strobePhaseOnTime = 0

-- this toggles the strobe on/off. If it's set to nil, the strobe is assumed to always be on.
local electricsToggleName = nil

-- this is to be used in jbeam
local electricsName = nil

-- the current timer used for phases
local timer = 0.0

local function updateGFX(dt)
  timer = timer + dt
  if timer > totalPhaseTime then timer = timer - totalPhaseTime end
  
  
  local phase = 0
  if timer > strobePhaseOffTime then phase = 1 end
  
  local toggleValue = 1
  if electrics.values[electricsToggleName] ~= nil then toggleValue = electrics.values[electricsToggleName] end
  
  --set strobe
  electrics.values[electricsName] = toggleValue > 0 and phase or 0
end

local function init(jbeamData)
  strobePhaseOffTime = jbeamData.strobePhaseOffTime or 1.5
  strobePhaseOnTime = jbeamData.strobePhaseOnTime or 0.075
  totalPhaseTime = strobePhaseOffTime + strobePhaseOnTime
  
  electricsName = jbeamData.electricsName or "strobeLight"
  electricsToggleName = jbeamData.electricsToggleName or nil
  electrics.values[electricsName] = 0
end

M.init = init
M.updateGFX = updateGFX

return M
