local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local modes = {}
local currentMode = nil

local electricsName
local modeElectricsName
local spoolUpRate = 1000.0
local spoolDownRate = 500.0

local speed = 0.0
local rotation = 0.0

local function setMode(name)
  if modes[name] then
    currentMode = name
    M.updateGFX(0.0)
  else
    log("E", "electricFan.setMode", "Can't find mode: " .. name)
  end
end

local function getMode()
  return currentMode
end

local function init(jbeamData)
  electricsName = jbeamData.electricsName
  modeElectricsName = jbeamData.modeElectricsName
  spoolUpRate = jbeamData.spoolUpRate or 1000.0
  spoolDownRate = jbeamData.spoolDownRate or 500.0
  
  if type(jbeamData.modes) == 'table' then
    for name,data in pairs(jbeamData.modes) do
      local copy = shallowcopy(data)
      copy.name = name
      modes[name] = copy
    end
  end
  
  if modeElectricsName then electrics.values[modeElectricsName] = 0.0 end
  if electricsName then electrics.values[electricsName] = 0.0 end
  
  -- create default "off" state
  modes["off"] =  {
    name = "off",
    rpm = 0.0,
    electricsValue = 0.0
  }
  setMode("off")
end

local function updateGFX(dt)
  local modeData = modes[currentMode]
  local targetSpeed = modeData.rpm or 0
  
  if targetSpeed < speed then
    speed = math.max(targetSpeed, speed - (dt * spoolDownRate))
  elseif targetSpeed > speed then
    speed = math.min(targetSpeed, speed + (dt * spoolUpRate))
  end
  
  rotation = (rotation + (speed * dt) ) % 360.0
  if modeElectricsName then
    electrics.values[modeElectricsName] = modeData.electricsValue or 0.0
  end
  if electricsName then
    --print("electrics.values[" .. electricsName .. "] = " .. tostring(rotation))
    electrics.values[electricsName] = rotation
  end
end

local function nop() end

-- public interface
M.init      = init
M.reset = nop
M.updateGFX = updateGFX

M.setMode = setMode
M.getMode = getMode

return M