-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local logTag = "bus"
M.type = "auxilliary"
M.relevantDevice = nil
M.defaultOrder = 1000

local wheelspeed = 0

local hasRegisteredQuickAccess = false

local htmlTexture = require("htmlTexture")
local destScreenName = nil
local destHtmlPath = nil
local NSdisplayScreenName = nil
local NSHtmlPath = nil

local currentLine = {}
local timer = 0
local curWaypoint = 1
local lastApproach = -1

local function getDoorOpen()
  return electrics.values["sidedoor"] >= 0.5
end

local function geCallback(event,data)
  data.event = event
  --transform userdata into table
  data.pos = vec3(obj:getPosition()):toTable()
  data.rot = quat(obj:getRotation()):toTable()
  obj:queueGameEngineLua("if core_busRouteManager then core_busRouteManager.onBusUpdate("..dumps(data)..") end")
end

local function updateGFX(dt)
  wheelspeed = electrics.values.wheelspeed or 0

  timer = timer + dt
  if timer > 0.5 then
    timer = timer % 0.5
    if currentLine.tasklist and currentLine.tasklist[curWaypoint] then
      --log("E",logTag,"pos ="..dumps(currentLine.tasklist[cur][3]))
      local dist = vec3(currentLine.tasklist[curWaypoint][3] ):distance(vec3(obj:getPosition()))
      -- log("E",logTag,"dist ="..tostring(dist))
      if dist < 75 and curWaypoint ~= lastApproach then
        controller.onGameplayEvent("bus_onApproachStop", {triggerName=currentLine.tasklist[curWaypoint][1]})
        lastApproach = curWaypoint
      end
    end
  end
end

local function reset()
  timer = 0
  curWaypoint = 1
  lastApproach = -1
end

local function registerQuickAccess()
  if not hasRegisteredQuickAccess and core_quickAccess ~= nil then
    core_quickAccess.addEntry({ level = '/', title = 'Bus', icon="material_directions_bus", ["goto"] = '/bus/'} )
    core_quickAccess.addEntry({ level = '/bus/', generator = function(entries)
          e = { title = 'ui.radialmenu2.bus.doors', icon="radial_hinges", onSelect = function() toggleDoors() return {'reload'} end }
          if electrics.values.open_doors == 1 then e.color = '#ff6600' end
          table.insert(entries, e)
        end})

    hasRegisteredQuickAccess = true
  end
end

local function init(jbeamData)
  if jbeamData.nextStopNode and v.data[jbeamData.nextStopNode] then
    local nsData = v.data[jbeamData.nextStopNode]
    NSdisplayScreenName = nsData.NSmaterialName
    NSHtmlPath = nsData.NShtmlPath
    local NSwidth = nsData.NStextureWidth or 512
    local NSheight = nsData.NStextureHeight or 384

    if NSHtmlPath and NSdisplayScreenName then
      htmlTexture.create(NSdisplayScreenName, NSHtmlPath, NSwidth, NSheight, 15, 'automatic')
    else
      log("E", logTag, "Got no html or material name path for NextStop, no HTML texture created!!!...")
    end
  end

  if jbeamData.destinationSignNode and v.data[jbeamData.destinationSignNode] then
    local destData = v.data[jbeamData.destinationSignNode]
    destScreenName = destData.destMaterialName or destScreenName
    destHtmlPath = destData.destHtmlPath
    local destWidth = destData.destTextureWidth or 256
    local destHeight = destData.destTextureHeight or 16
    local destText = destData.destText or ""
    local destRoute = destData.destRoute or ""

    if destHtmlPath and destScreenName then
      htmlTexture.create(destScreenName, destHtmlPath, destWidth, destHeight, 4, 'automatic')
      htmlTexture.call(destScreenName, "update", {direction = destText, routeID = destRoute} )
    else
      log("E", logTag, "Got no html path or material name for destination, no HTML texture created!!!...")
    end
  end
  --registerQuickAccess()
end

local function recalculateStopList()
  local sl = {}
  for i = curWaypoint, #currentLine.tasklist, 1 do
    table.insert(sl, currentLine.tasklist[i][2])
  end
  return sl
end

--duplicate code at scenario/busdriver.lua:62
local function isTriggerOnBusLine(tasks,tname)
  for _,v in pairs(tasks) do
    if v[1] == tname then return true end
  end
  return false
end

local function uiSetLine(routeID, variance)
  obj:queueGameEngineLua("if core_busRouteManager then core_busRouteManager.setLine("..tostring(obj:getID())..","..dumps(routeID)..","..dumps(variance)..") end")
end

local function onGameplayEvent(eventName, eventData)
  if eventName == "bus_onRouteChange" then
    if destScreenName then
      htmlTexture.call(destScreenName, "update", eventData)
    end
    if NSdisplayScreenName then
      htmlTexture.call(NSdisplayScreenName, "updateDisplay", eventData)
    end
    guihooks.trigger('BusDisplayUpdate', eventData)
  elseif eventName == "bus_onDepartedStop" then
    if not currentLine.tasklist or #currentLine.tasklist == 0 then
      log("E",logTag,"No tasklist!")
      return
    end
    if not isTriggerOnBusLine(currentLine.tasklist, eventData.triggerName) then return end

    --fix spawning the bus in last busstop trigger, you still cannot go through, only exit once
    if currentLine.tasklist[#currentLine.tasklist][1] == eventData.triggerName and curWaypoint<#currentLine.tasklist  then
      return
    end

    for i=1, #currentLine.tasklist, 1 do
      if currentLine.tasklist[i][1] == eventData.triggerName then curWaypoint=i;break end
    end
    curWaypoint = curWaypoint + 1

    local stopList = recalculateStopList()

    if NSdisplayScreenName then
      htmlTexture.call(NSdisplayScreenName, "updateDisplay", stopList)
    end
    guihooks.trigger('BusDisplayUpdate', stopList)
    geCallback("onDepartedStop",eventData)

  elseif eventName == "bus_onAtStop" then
    if not currentLine.tasklist or #currentLine.tasklist == 0 then
      log("E",logTag,"No tasklist!")
      return
    end
    if not isTriggerOnBusLine(currentLine.tasklist, eventData.triggerName) then return end

    for i = 1, #currentLine.tasklist, 1 do
      if currentLine.tasklist[i][1] == eventData.triggerName then curWaypoint = i; break end
    end

    geCallback("onAtStop", eventData)

  elseif eventName == "bus_onApproachStop" then
    -- guihooks.trigger('Message', {ttl = 5, msg = 'onApproachStop', icon = 'directions_bus'})

    for i = 1, #currentLine.tasklist, 1 do
      if currentLine.tasklist[i][1] == eventData.triggerName then curWaypoint = i; break end
    end

    geCallback("onApproachStop", eventData)

  elseif eventName == "bus_setLineInfo" then
    -- log("I",logTag..".setLineInfo","eventData received in lua veh ="..dumps(eventData))
    reset()
    currentLine = eventData
    controller.onGameplayEvent("bus_onRouteChange", currentLine)
    -- if currentLine.tasklist[1] then
    --   controller.onGameplayEvent("bus_onAtStop",{triggerName=currentLine.tasklist[1][1]})
    -- end

  elseif eventName == "bus_onTriggerTick" then
    eventData.speed = electrics.values.wheelspeed * 3.6
    eventData.bus_dooropen = getDoorOpen()
    eventData.bus_kneel = electrics.values.wheelspeed < 1.0 and getDoorOpen()
    geCallback("onTriggerTick",eventData)
  end
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX
M.onGameplayEvent = onGameplayEvent

M.toggleDoors = function() if electrics.values.open_doors > 0.5 then electrics.values.open_doors = 0 else electrics.values.open_doors = 1 end end

M.uiSetLine = uiSetLine

return M
