local M = {}
local storageMain = nil
local storagePrimary = nil
local storageSecondary = nil

local function sync()
  if storageMain and storagePrimary and storageSecondary then
    storagePrimary:setRemainingMass(storageMain:getRemainingMass())
    storageSecondary:setRemainingMass(storageMain:getRemainingMass())
  end
end

local function updateGFX(dt)
  sync()
end

local function onReset()
  sync()
end

local function onInit()
  storageMain = energyStorage.getStorage("mainAirTank")
  storagePrimary = energyStorage.getStorage("primaryAirTank")
  storageSecondary = energyStorage.getStorage("secondaryAirTank")
  sync()
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M
