local M = {}

local batteryVoltageAmt = 0
local tempAmt = 0
local oilPresAmt = 0
local fuelAmt = 0
local primaryAirAmt = 0
local secondaryAirAmt = 0
local rpmAmt = 0
local speedAmt = 0
local lowPrimaryAir = false
local lowSecondaryAir = false
local highTemp = false

local doingGaugeSweep = false
local gaugeSweepDuration = 1.85
local gaugeSweepMoveTime = 0.85
local gaugeSweepTimer = 0
local lastIgnitionLevel = 2

local function moveTowards(current, target, maxmove)
  if target < current then
    return math.max(target, current - maxmove)
  elseif target > current then
    return math.min(target, current + maxmove)
  end
  return current
end

local function onInit()
	electrics.values['a3_tempgauge'] = 0
  electrics.values['a3_batgauge'] = 0
  electrics.values['a3_hightemp'] = 0
  electrics.values['a3_oilpres'] = 0
  electrics.values['a3_fuelgauge'] = 0
  
  electrics.values['a3_primaryair'] = 0
  electrics.values['a3_secondaryair'] = 0
  
  electrics.values['a3_speed'] = 0
  electrics.values['a3_rpm'] = 0
  
  electrics.values['a3_lowprimair'] = 0
  electrics.values['a3_lowsecair'] = 0
end

local function onReset()

end

local function initGaugeSweep()
  gaugeSweepTimer = 0
  doingGaugeSweep = true
end

local function updateGaugeSweep(dt)
  gaugeSweepTimer = gaugeSweepTimer + dt
  if gaugeSweepTimer >= gaugeSweepDuration then
    doingGaugeSweep = false
  end
  
  local sweepAmount = math.min(1.0, gaugeSweepTimer / gaugeSweepMoveTime)
  tempAmt = sweepAmount
  batteryVoltageAmt = sweepAmount
  fuelAmt = sweepAmount
  oilPresAmt = sweepAmount
  primaryAirAmt = sweepAmount
  secondaryAirAmt = sweepAmount
  speedAmt = sweepAmount
  rpmAmt = sweepAmount
  
  lowPrimaryAir = false
  lowSecondaryAir = false
  highTemp = false
end

local function updateOff(dt)
  tempAmt = moveTowards(tempAmt, 0, dt)
  batteryVoltageAmt = moveTowards(batteryVoltageAmt, 0, dt)
  fuelAmt = moveTowards(fuelAmt, 0, dt)
  oilPresAmt = moveTowards(oilPresAmt, 0, dt)
  primaryAirAmt = moveTowards(primaryAirAmt, 0, dt)
  secondaryAirAmt = moveTowards(secondaryAirAmt, 0, dt)
  speedAmt = moveTowards(speedAmt, 0, dt)
  rpmAmt = moveTowards(rpmAmt, 0, dt)
  
  lowPrimaryAir = false
  lowSecondaryAir = false
  highTemp = false
end

local function updateRunning(dt)
  local temp = electrics.values.watertemp or 0
  local normalizedTemp = math.min(1, math.max(0, (temp - 37.7778) / (126.667 - 37.7778)))
  tempAmt = moveTowards(tempAmt, normalizedTemp, dt)
  highTemp = (temp >= 110)
 
  batteryVoltageAmt = moveTowards(batteryVoltageAmt, 12.0/16.0, dt) -- target 12 volts 
  
  local curFuel = electrics.values.fuel or 0
  fuelAmt = moveTowards(fuelAmt, curFuel or 0, dt)
  
  local engineRunning = electrics.values.engineRunning or 0
  oilPresAmt = moveTowards(oilPresAmt, engineRunning * 0.46, dt)
  
  local primaryAir = electrics.values["primaryAirTank_pressureRelative"] or 0
  local secondaryAir = electrics.values["secondaryAirTank_pressureRelative"] or 0
  local primaryAirPSI = primaryAir / 6895
  local secondaryAirPSI = secondaryAir / 6895
  
  local normalizedPrimaryAir = math.min(1.0, primaryAirPSI / 150.0)
  local normalizedSecondaryAir = math.min(1.0, secondaryAirPSI / 150.0)
  primaryAirAmt = moveTowards(primaryAirAmt, normalizedPrimaryAir, dt)
  secondaryAirAmt = moveTowards(secondaryAirAmt, normalizedSecondaryAir, dt)
  lowPrimaryAir = (primaryAirPSI <= 65)
  lowSecondaryAir = (secondaryAirPSI <= 65)
  
  local speed = electrics.values.wheelspeed or 0
  local speedMPH = speed * 2.23694
  local normalizedSpeed = math.min(1.0, math.max(0.0, speedMPH / 90.0))
  speedAmt = moveTowards(speedAmt, normalizedSpeed, dt)
  
  local rpm = electrics.values.rpm or 0
  local normalizedRpm = math.min(1.0, math.max(0.0, rpm / 3000.0))
  rpmAmt = moveTowards(rpmAmt, normalizedRpm, dt)
end

local function applyValues(dt)
  electrics.values['a3_fuelgauge'] = fuelAmt
  electrics.values['a3_tempgauge'] = tempAmt
  electrics.values['a3_batgauge'] = batteryVoltageAmt
  electrics.values['a3_oilpres'] = oilPresAmt
  
  electrics.values['a3_hightemp'] = (highTemp and 1 or 0)
  
  electrics.values['a3_primaryair'] = primaryAirAmt
  electrics.values['a3_secondaryair'] = secondaryAirAmt
  
  electrics.values['a3_lowprimair'] = (lowPrimaryAir) and 1 or 0
  electrics.values['a3_lowsecair'] = (lowSecondaryAir) and 1 or 0
  
    electrics.values['a3_speed'] = speedAmt
  electrics.values['a3_rpm'] = rpmAmt
end

local function updateGFX(dt)
  local ignitionLevel = electrics.values.ignitionLevel or 0
  if ignitionLevel > 0 and lastIgnitionLevel == 0 then
    initGaugeSweep()
  end
  
  if ignitionLevel == 0 then
    updateOff(dt)
  elseif doingGaugeSweep then
    updateGaugeSweep(dt)
  else
    updateRunning(dt)
  end
  
  applyValues(dt)
  lastIgnitionLevel = ignitionLevel
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M
