
angular.module('gaugesScreen', [])
  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;

    var speedoDisplay = { gears: {} };
	var tacho = {  };
	var text = {  };
    var infoDisplay = {};
    var consumGraph = {values:{current: 0,avg: 0}};
    var electrics = {lights:{} };
    var gForcesVisible = false;

    var backgroundGradient = {};
    var overlayGradient = {};
    // var backgroundClipGradient;

    var speedoInitialised = false;
    var currentGear = '';
    var prevspeedAng = 0;

    var ready = false;

    var unit = "metric";
	var units = {uiUnitTemperature: "c"};
    var unitspeedratio = 3.6/260*Math.PI*1.5;

    function setTheme(hue) {

      // info
      infoDisplay.infoOverlay.css({'stroke': `hsl(${hue}, 100%, 30%)`, 'stroke-width': '0.5px'});

      // gradients
      overlayGradient.stop1.css({stopColor: `hsl(${hue}, 100%, 20%)`})
      overlayGradient.stop2.css({stopColor: `hsl(${hue}, 100%, 10%)`})

      backgroundGradient.stop1.css({"stop-color": `hsl(${hue}, 100%, 0%)`})
      backgroundGradient.stop2.css({"stop-color": `hsl(${hue}, 100%, 0%)`})

      // background color
      $element[0].style.backgroundColor = "black";
      //$element[0].style.backgroundColor = `hsl(${hue}, 70%, 20%)`;
    }

    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[1].children[0];

      // speedometer
      speedoDisplay.root = hu('#speedometer', svg);
      speedoDisplay.speedometerText = hu('#speedometerText', speedoDisplay.root)
      speedoDisplay.speedValue = hu('#speedValue', speedoDisplay.speedometerText);
      speedoDisplay.speedUnit = hu('#speedUnit', speedoDisplay.speedometerText);
      speedoDisplay.speedTicks = hu('#speedTicks', speedoDisplay.speedometerText);
      speedoDisplay.gears.P = hu('#gearP', speedoDisplay.speedometerText);
      speedoDisplay.gears.R = hu('#gearR', speedoDisplay.speedometerText);
      speedoDisplay.gears.N = hu('#gearN', speedoDisplay.speedometerText);
      speedoDisplay.gears.D = hu('#gearD', speedoDisplay.speedometerText);
      speedoDisplay.gears.S = hu('#gearS', speedoDisplay.speedometerText);
	  speedoDisplay.GearNumb = hu('#GearNumb', speedoDisplay.speedometerText);
      speedoDisplay.needle = hu('#needle', speedoDisplay.root);
      speedoDisplay.needle.attr({class: "fade-in"}).css({stroke: "#00ffff"});
      speedoDisplay.needle_bar = hu('#needle_bar', speedoDisplay.root);
      speedoDisplay.needle_bar.attr({class: "fade-in"});
      speedoDisplay.needle_gradients = [];
      speedoDisplay.needle_gradients.push(hu('#radialGradient965', svg));
      speedoDisplay.needle_gradients.push(hu('#radialGradient977', svg));
	  
	  tacho.needle_tacho = hu('#needle_tacho', speedoDisplay.root);
      tacho.needle_tacho.attr({class: "fade-in"});
	  tacho.rpmValue = hu('#rpmValue', speedoDisplay.speedometerText);
	  speedoDisplay.needle_boost = hu('#needle_boost', speedoDisplay.root);
      speedoDisplay.needle_boost.attr({class: "fade-in"});
	  speedoDisplay.waterTempValue = hu('#waterTempValue', speedoDisplay.speedometerText);
	  speedoDisplay.oilTempValue = hu('#oilTempValue', speedoDisplay.speedometerText);
	  speedoDisplay.AverageTempValue = hu('#AverageTempValue', speedoDisplay.speedometerText);
	  
	  text.temp_unit = hu('#temp_unit', speedoDisplay.root);
	  text.temp_unit2 = hu('#temp_unit2', speedoDisplay.root);
	  text.temp_unit3 = hu('#temp_unit3', speedoDisplay.root);
	  text.temp_unit4 = hu('#waterTempUnit', speedoDisplay.root);
	  text.temp_unit5 = hu('#oilTempUnit', speedoDisplay.root);
	  text.temp_unit6 = hu('#AverageTempUnit', speedoDisplay.root);
      text.outside_temp = hu('#outside_temp', speedoDisplay.root);
	  text.time = hu('#time', speedoDisplay.root);

      // info
      infoDisplay.root = hu('#information', svg);
      infoDisplay.infoOverlay = hu('#infoOverlay', infoDisplay.root);
      infoDisplay.infoValues = hu('#infoValues', infoDisplay.root);
      // var ivbox = infoDisplay.root.n.getBBox()
      // console.log("infovalu", ((ivbox.y+ivbox.width/2)/svg.getBBox().width)*100,((ivbox.x+ivbox.height/2)/svg.getBBox().height)*100)

      infoDisplay.accelerometer = hu('#accelerometer', infoDisplay.root);
      infoDisplay.accelerometerMarker = hu('#accelerometerMarker', infoDisplay.accelerometer);
      infoDisplay.gXNegative = hu('#gXNegative', infoDisplay.root);
      infoDisplay.gXPositive = hu('#gXPositive', infoDisplay.root);
      infoDisplay.gYNegative = hu('#gYNegative', infoDisplay.root);
      infoDisplay.gYPositive = hu('#gYPositive', infoDisplay.root);

      consumGraph.root = hu('#consum_graph_layer', svg);
      // var cbox = consumGraph.root.n.getBBox()
      // console.log("consum_graph_layer", ((cbox.y+cbox.width/2)/svg.getBBox().width)*100,((cbox.x+cbox.height/2)/svg.getBBox().height)*100)
      consumGraph.graph_canvas = document.getElementById('consum_graph_canvas');
      consumGraph.graph_canvas_ctx = consumGraph.graph_canvas.getContext("2d");
      consumGraph.graph_canvas_gradiant_o = consumGraph.graph_canvas_ctx.createLinearGradient(0,0,0,consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_gradiant_o.addColorStop(0, 'rgba(0,204,153,0.5)');
      consumGraph.graph_canvas_gradiant_o.addColorStop(0.6, 'rgba(0,204,153,0)');
      consumGraph.graph_canvas_gradiant_o.addColorStop(1, 'rgba(0,204,153,0)');
      consumGraph.graph_canvas_gradiant_g = consumGraph.graph_canvas_ctx.createLinearGradient(0,0,0,consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_gradiant_g.addColorStop(0, 'rgba(51,51,255,0)');
      consumGraph.graph_canvas_gradiant_g.addColorStop(0.75, 'rgba(51,51,255,0)');
      consumGraph.graph_canvas_gradiant_g.addColorStop(1, 'rgba(51,51,255,0.5)');

      infoDisplay.accelerometer.css({opacity: 0})
      infoDisplay.infoValues.css({opacity: 0})
      infoDisplay.infoValuesTxt = { range: hu('#rangeTxt', infoDisplay.infoValues),
        now: hu('#nowTxt', infoDisplay.infoValues),
        avg: hu('#avgTxt', infoDisplay.infoValues),
        odo: hu('#odoTxt', infoDisplay.infoValues),
      };

      // animations
      speedoDisplay.root.attr({class: "fade-in"}).on('webkitAnimationEnd', function (){
        //speedoDisplay.needle.attr({class: "rotate"});
      });
      speedoInitialised = true;
      speedoDisplay.needle.on('webkitAnimationEnd', function (){
        speedoInitialised = true;
      });

      speedoDisplay.speedometerText.attr({class: "fade-in"})
      infoDisplay.root.attr({class: "slide-right"});
      var background = hu('#background', svg);
      background.attr({class: 'map-fade'})

      // gradients
      overlayGradient.stop1 = hu('#overlayStop1', svg);
      overlayGradient.stop2 = hu('#overlayStop2', svg);
      backgroundGradient.stop1 = hu('#bgStop1', svg);
      backgroundGradient.stop2 = hu('#bgStop2', svg);

      electrics.root = hu('#lights_layer', svg);
      electrics.lights.signal_L = hu("#light_signal_L", electrics.root);
      electrics.lights.signal_R = hu("#light_signal_R", electrics.root);
      electrics.lights.lowbeam = hu("#light_lights", electrics.root);
      electrics.lights.highbeam = hu("#light_highbeam", electrics.root);
      electrics.lights.fog = hu("#light_fog", electrics.root);
      electrics.lights.lowpressure = hu("#light_lowpressure", electrics.root);
      electrics.esc = hu("#light_escActive", electrics.root);
      electrics.lights.parkingbrake = hu("#light_parkingbrake", electrics.root);
      electrics.lights.checkengine = hu("#light_checkengine", electrics.root);
      electrics.lights.lowfuel = hu("#light_battery", electrics.root);
	  electrics.lights.cruiseControlActive = hu('#cruisecontrol_light', electrics.root)
	  electrics.lights_hybridReady = hu('#ready_light', electrics.root) // hybrid
      electrics.fuelTxt = hu("#fuelTxt", speedoDisplay.speedometerText);
      electrics.fuelStops = [hu("#stop_fuel1", svg), hu("#stop_fuel2", svg)];
	  electrics.FuelkWStops = [hu("#stop_battery1", svg), hu("#stop_battery2", svg)];
	  electrics.currentPowerStops = [hu("#stop_currentPower1", svg), hu("#stop_currentPower2", svg)];
	  electrics.EVcurrentPowerStops = [hu("#stop_EVcurrentPowerStops1", svg), hu("#stop_EVcurrentPowerStops2", svg)];
	  electrics.waterStops = [hu("#stop_water1", svg), hu("#stop_water2", svg)];
	  electrics.oilStops = [hu("#stop_oil1", svg), hu("#stop_oil2", svg)];
	  electrics.averageStops = [hu("#stop_average1", svg), hu("#stop_average2", svg)];

      if(new Date().getDate() ==1 && new Date().getMonth() == 3){
        var ellogo = hu('#imageLogo', svg);
        if(ellogo)ellogo.attr({href: "/core/art/missingTexture.png"});
      }
      setTheme(200);

      //default `Comfort` display graph and conso
      infoDisplay.accelerometer.css({opacity: 0});
      consumGraph.root.css({opacity: 1});
      consumGraph.graph_canvas.style.display = "inline";
      infoDisplay.infoValues.css({opacity: 1});
    }

    function updateGearIndicator(data) {
      // only update when gear is changed
      if (currentGear !== data.electrics.gear) {
        currentGear = data.electrics.gear;
        for (var key in speedoDisplay.gears) {
          if (key === data.electrics.gear) {
            speedoDisplay.gears[key].css({ fill: '#d8d8d8' })
			speedoDisplay.GearNumb.text(data.electrics.gear).css({ fill: '#d8d8d8' });
          }
          else {
            speedoDisplay.gears[key].css({ fill: '#616161' })
			speedoDisplay.GearNumb.text(data.electrics.gear).css({ fill: '#d8d8d8' });
          }
        }
      }
    }

    function updateTachoDisplays(data) {
    if (speedoInitialised) {

        const rpmTacho = data.electrics.rpmTacho || 0;
		
		tacho.rpmValue.text((Math.round(data.electrics.rpmTacho / 100) * 100).toFixed(0));

        // Минимальный и максимальный масштаб изображения
        const minScale = 1; // Исходный размер
        const maxScale = 2.1; // Максимальное увеличение

        // Вычисляем масштаб в зависимости от оборотов
        const scale = minScale + (maxScale - minScale) * Math.min(rpmTacho, 8400) / 8400;

        // Центрирование для масштабирования
        const centerX = 67.6; // Укажите точный центр вашего изображения по X
        const centerY = 27.0; // Укажите точный центр вашего изображения по Y

        // Обновляем трансформацию для тега <image>
        tacho.needle_tacho.attr({
        transform: `translate(${centerX}, ${centerY}) scale(${scale}) translate(${-centerX}, ${-centerY})`
        });
      }
    }
	
	function updateBoostDisplays(data) {
    if (speedoInitialised) {

        const turboBoost = data.electrics.turboBoost || 0;

        // Минимальный и максимальный масштаб изображения
        const minScale = 1; // Исходный размер
        const maxScale = -1.1; // Максимальное увеличение

        // Вычисляем масштаб в зависимости от оборотов
        const scale = minScale + (maxScale - minScale) * Math.min(turboBoost * 0.007);

        // Центрирование для масштабирования
        const centerX = 67.6; // Укажите точный центр вашего изображения по X
        const centerY = 27.0; // Укажите точный центр вашего изображения по Y

        // Обновляем трансформацию для тега <image>
        speedoDisplay.needle_boost.attr({
        transform: `translate(${centerX}, ${centerY}) scale(${scale}) translate(${-centerX}, ${-centerY})`
        });
      }
    }

	function updateSpeedDisplays(data) {
      if (speedoInitialised) {
        var speedAng = 226 + ((data.electrics.wheelspeed * 2.35));
        var startAngle=-227*Math.PI/180, speedRad = (data.electrics.wheelspeed*unitspeedratio)+startAngle;
        var maxRad = (275*Math.PI/180) + startAngle;
        speedRad = Math.min(speedRad, maxRad);
        //console.log("maxRad",maxRad,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad-startAngle)*180/Math.PI);
        if(Math.abs(speedRad-prevspeedAng)<0.3){return;}
        speedoDisplay.speedValue.text((data.electrics.wheelspeed * (unit=="metric"?3.6:2.23694) ).toFixed(0));
        //speedoDisplay.needle.css({transform: `rotate(${speedAng}deg)` });

        var centerX=67.4, centerY=33, radiusInt=19.5, radiusExt=21, largeArcFlag= ((speedRad-startAngle)>Math.PI)? 1 : 0;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

        var ex1 = (centerX) + Math.cos(speedRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(speedRad) * radiusInt;

        var mx1 = (centerX) + Math.cos(speedRad) * 8;
        var my1 = (centerY) + Math.sin(speedRad) * 8;

        speedoDisplay.needle_bar.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2});
        speedoDisplay.needle.attr({d: "M " + ex1 + "," + ey1 + " " +mx1+","+my1});

        for(var E in speedoDisplay.needle_gradients){
          speedoDisplay.needle_gradients[E].attr({cx:ex1,cy:ey1,fx:ex1,fy:ey1});
        }

        prevspeedAng = speedAng;
      }
    }

    function limitVal(min, val,max){
        return Math.min(Math.max(min,val), max);
    }

    function updateAccelerometer(data) {
      infoDisplay.accelerometer.css({opacity: 1})
      infoDisplay.accelerometerMarker.css({transformOrigin: '50% 50%', transform: `translate(${limitVal(-10,data.customModules.accelerationData.xSmooth,10)/1.4}px, ${-limitVal(-10,data.customModules.accelerationData.ySmooth,10)/1.4}px`})
      var roundedGX2 = (data.customModules.accelerationData.xSmooth / 10).toFixed(1);
      var roundedGY2 = (-data.customModules.accelerationData.ySmooth / 10).toFixed(1);
      infoDisplay.gXPositive.text(roundedGX2 > 0 ? roundedGX2  : 0)
      infoDisplay.gXNegative.text(roundedGX2 < 0 ? -roundedGX2 : 0)
      infoDisplay.gYNegative.text(roundedGY2 > 0 ? roundedGY2  : 0)
      infoDisplay.gYPositive.text(roundedGY2 < 0 ? -roundedGY2 : 0)
    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      //console.log("setUnits", data.unit);
      unit = data.uiUnitLength;
      if( unit == "metric"){
        unitspeedratio = 3.6/data.maxKPH*Math.PI*1.5;
        speedoDisplay.speedUnit.text("km/h");
      }
      else{
		if (unit === "imperial") {
            unitspeedratio = 2.23694/data.maxMPH*Math.PI*1.5;
            speedoDisplay.speedUnit.text("mph");
	    }
      }
	  units.uiUnitTemperature = data.uiUnitTemperature || ""
    }


    $window.initMap = (data) => {
    }

    $window.updateMap = (data) => {
    }

    var hue = 0;

    function appendGraphConsumption(data)  {
      var newCurrent = data.customModules.combustionEngineData.averageConsumption
      if( newCurrent === undefined || newCurrent === null)
        return;
      newCurrent = newCurrent * 0.001
      var unitOffset = -300, unitY = 1200, stepPx=4;
      if( consumGraph.graph_canvas_ctx == undefined){
        console.error(consumGraph);
        return;
      }
      var colors = ["#515151", "#2f2f2f"];//consum, regen

      //var prevGraph = consumGraph.graph_canvas_ctx.createImageData(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_ctx.putImageData(consumGraph.graph_canvas_ctx.getImageData(stepPx, 0, consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height), 0, 0);
      //consumGraph.graph_canvas_ctx.drawImage(consumGraph.graph_canvas, -stepPx, 0);
      consumGraph.graph_canvas_ctx.clearRect(consumGraph.graph_canvas.width-stepPx, 0, stepPx, consumGraph.graph_canvas.height);
      //consumGraph.graph_canvas_ctx.fillRect(consumGraph.graph_canvas.width-stepPx, 0, stepPx, consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_ctx.strokeStyle = colors[0];
      consumGraph.graph_canvas_ctx.lineWidth = 2;
      consumGraph.graph_canvas_ctx.beginPath();
      if(consumGraph.values.current >0 && newCurrent>0){ //ALL ORANGE
        consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY );
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.stroke();
        consumGraph.graph_canvas_ctx.beginPath();
        consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY );
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.closePath();
        consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_o;
        consumGraph.graph_canvas_ctx.fill();
      }
      else if(consumGraph.values.current <=0 && newCurrent<=0){ //ALL GREEN
        consumGraph.graph_canvas_ctx.strokeStyle = colors[1];
        consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY );
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.stroke();
        consumGraph.graph_canvas_ctx.beginPath();
        consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY );
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
        consumGraph.graph_canvas_ctx.closePath();
        consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_g;
        consumGraph.graph_canvas_ctx.fill();
      }
      else{//TRANSITION
        var bp = stepPx*(consumGraph.values.current)/(consumGraph.values.current - newCurrent);
        if(consumGraph.values.current < newCurrent){ //UP
          consumGraph.graph_canvas_ctx.strokeStyle = colors[1];
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.stroke();
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.closePath();
          consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_g;
          consumGraph.graph_canvas_ctx.fill();

          consumGraph.graph_canvas_ctx.strokeStyle = colors[0];
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.stroke();
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.closePath();
          consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_o;
          consumGraph.graph_canvas_ctx.fill();
        }
        else{ //DW
          consumGraph.graph_canvas_ctx.strokeStyle = colors[0];
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.stroke();
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(consumGraph.values.current-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width-stepPx, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.closePath();
          consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_o;
          consumGraph.graph_canvas_ctx.fill();

          consumGraph.graph_canvas_ctx.strokeStyle = colors[1];
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.stroke();
          consumGraph.graph_canvas_ctx.beginPath();
          consumGraph.graph_canvas_ctx.moveTo(consumGraph.graph_canvas.width-stepPx+bp, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY );
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(newCurrent-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.lineTo(consumGraph.graph_canvas.width, consumGraph.graph_canvas.height-(0-unitOffset)*consumGraph.graph_canvas.height/unitY);
          consumGraph.graph_canvas_ctx.closePath();
          consumGraph.graph_canvas_ctx.fillStyle = consumGraph.graph_canvas_gradiant_g;
          consumGraph.graph_canvas_ctx.fill();
        }
      }
      consumGraph.values.current = newCurrent;
    }

    function updateConsumption(data) {
      infoDisplay.infoValuesTxt.now.text( (data.customModules.combustionEngineData.currentPower / 1.35962).toFixed(0) + " kW" ); //PS to kW

      // Определяем диапазон мощности в PS
	  const maxPowerNm = 621; // Укажите ваш максимальный диапазон мощности бензинового двигателя PS
	  const maxPowerkW = 813; // Укажите ваш максимальный диапазон мощности электродвигателя PS

	  // Целевое значение для шкалы
	  const OffsetcurrentPower = Math.min(Math.max(data.customModules.combustionEngineData.currentPower / maxPowerNm, 0), 1);
	  const OffsetEVcurrentPower = Math.min(Math.max((data.customModules.electricMotorData.currentPower / maxPowerkW) / 1.35962, 0), 1);

	  // Шкала combustionEngineData
	  if (electrics.currentPowerStops[0] && electrics.currentPowerStops[1]) {
	      electrics.currentPowerStops[0].attr({ offset: OffsetcurrentPower });
	      electrics.currentPowerStops[1].attr({ offset: OffsetcurrentPower + 0.001 });
	  }
	  // Шкала electricMotorData
	  if (electrics.EVcurrentPowerStops[0] && electrics.EVcurrentPowerStops[1]) {
	      electrics.EVcurrentPowerStops[0].attr({ offset: OffsetEVcurrentPower });
	      electrics.EVcurrentPowerStops[1].attr({ offset: OffsetEVcurrentPower + 0.001 });
	  }

      if(data.customModules.combustionEngineData.averagePower == undefined || data.customModules.combustionEngineData.remainingRange == undefined){return;}
      infoDisplay.infoValuesTxt.avg.text( (data.customModules.combustionEngineData.averagePower / 1.35962).toFixed(0) + " kW" ); //PS to kW
      infoDisplay.infoValuesTxt.range.text( (data.customModules.combustionEngineData.remainingRange).toFixed(0) + (unit==="metric"?" km":" mi") );
    }


    function setElec(val, state, key){
      if( val === undefined || val === null){/*console.error("setElec: svg element not found", key);*/ return;}
      if( state === undefined || state === null){/*console.error("setElec: state not found", key);*/ return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
    }

    $window.updateElectrics = (data) => {
      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }
	  
	  if(data.electrics.cruiseControlActive === undefined){data.electrics.cruiseControlActive = false}
	  
	  if(units.uiUnitTemperature == "c" || units.uiUnitTemperature == "k"){
        let envTemp = data.customModules.environmentData.temperatureEnv
		text.outside_temp.text( envTemp.toFixed(0) );
		let envTempWater = data.electrics.watertemp
		speedoDisplay.waterTempValue.text( envTempWater.toFixed(0) );
		let envTempOil = data.electrics.oiltemp
		speedoDisplay.oilTempValue.text( envTempOil.toFixed(0) );
		let envTempAverage = ((data.electrics.oiltemp + data.electrics.watertemp) / 2)
		speedoDisplay.AverageTempValue.text( envTempAverage.toFixed(0) );
        text.temp_unit.text( "°C" );
		text.temp_unit2.text( "°C" );
		text.temp_unit3.text( "°C" );
		text.temp_unit4.text( "°C" );
		text.temp_unit5.text( "°C" );
		text.temp_unit6.text( "°C" );
      }else{
        let envTemp = (data.customModules.environmentData.temperatureEnv * 9/5) + 32
		text.outside_temp.text( envTemp.toFixed(0) );
		let envTempWater = (data.electrics.watertemp * 9/5) + 32
		speedoDisplay.waterTempValue.text( envTempWater.toFixed(0) );
		let envTempOil = (data.electrics.oiltemp * 9/5) + 32
		speedoDisplay.oilTempValue.text( envTempOil.toFixed(0) );
		let envTempAverage = (((data.electrics.oiltemp + data.electrics.watertemp) / 2) * 9/5) + 32
		speedoDisplay.AverageTempValue.text( envTempAverage.toFixed(0) );
        text.temp_unit.text( "°F" );
		text.temp_unit2.text( "°F" );
		text.temp_unit3.text( "°F" );
		text.temp_unit4.text( "°F" );
		text.temp_unit5.text( "°F" );
		text.temp_unit6.text( "°F" );
      }
	  
	  // Константы
	  const maxFuel = 76; // Максимальный объем бака в литрах
	  const fuelConsumption = 14.3; // Средний расход топлива в л/100 км

	  // Получение текущего значения топлива (доля от полного бака)
	  const currentFuelFraction = data.electrics.fuel;

	  // Переводим в литры
	  const currentFuel = currentFuelFraction * maxFuel;

	  // Рассчитываем оставшийся пробег в километрах
	  let remainingRange = (currentFuel / fuelConsumption) * 100;

	  // Конвертируем в мили, если выбрана система "imperial"
	  if (unit === "imperial") {
	  remainingRange *= 0.621371; // Перевод из километров в мили
	  }

	  // Обновляем текстовое отображение с единицами измерения
	  electrics.fuelTxt.text(remainingRange.toFixed(0) + (unit === "metric" ? " km" : " mi"));

	  electrics.fuelStops[0].attr({offset: data.electrics.fuel})
      electrics.fuelStops[1].attr({offset: data.electrics.fuel+0.001})
	  
    // Переменная для текущего значения температуры воды (начинаем с 0)
    let currentWaterTemp = 0;

    // Скорость изменения (0.1 = медленно, 0.5 = быстрее)
    const changeSpeed = 0.778;
	
    // Функция для масштабирования
    const scaleToOffset = (value, min, max) => {
        return Math.min(Math.max((value - min) / (max - min), 0), 1);
    };
	
	// Целевое значение температуры воды
    const targetWaterTemp = scaleToOffset(data.electrics.watertemp || 0, 20, 130);
	
	// Целевое значение температуры масла
    const oilTempOffset = scaleToOffset(data.electrics.oiltemp || 0, 30, 185);
	
	// Вычисляем среднее значение
	const AverageTempOffset = scaleToOffset((data.electrics.watertemp + data.electrics.oiltemp) / 2 || 0, 35, 195);
	
	// Интерполяция для плавного изменения температуры воды
    currentWaterTemp += (targetWaterTemp - currentWaterTemp) * changeSpeed;
	  
	// Обновляем градиент
    if (electrics.waterStops[0] && electrics.waterStops[1]) {
        electrics.waterStops[0].attr({ offset: currentWaterTemp });
        electrics.waterStops[1].attr({ offset: currentWaterTemp + 0.001 });
    }
	
	if (electrics.oilStops[0] && electrics.oilStops[1]) {
        electrics.oilStops[0].attr({ offset: oilTempOffset });
        electrics.oilStops[1].attr({ offset: oilTempOffset + 0.001 });
    }
	
	// Обновляем средний датчик
    if (electrics.averageStops[0] && electrics.averageStops[1]) {
        electrics.averageStops[0].attr({ offset: AverageTempOffset });
        electrics.averageStops[1].attr({ offset: AverageTempOffset + 0.001 });
    }
	
      electrics.lights_hybridReady.n.style.display = (data.electrics.running==0 || data.electrics.running===1)?"none":"inline";
	  electrics.esc.n.style.display = (data.electrics["escActive"] || data.electrics["esc"]==1 || data.electrics["tcsActive"] || data.electrics["tcs"]==1 ) ?"inline":"none";
      if( electrics.esc.n.classList.contains("blink") !== (data.electrics["escActive"] || data.electrics["tcsActive"])){
        electrics.esc.n.classList.toggle("blink", (data.electrics["escActive"] || data.electrics["tcsActive"]));
      }
      if(data.electrics.odometer){
        let val = data.electrics.odometer
        val *= (unit=="metric")?0.001:0.0006215;
        val = Math.min(val,999999)
        infoDisplay.infoValuesTxt.odo.text( val.toFixed(0) + (unit==="metric"?" km":" mi") );
      }
    }
	
	function fixClock(v, fill="0"){
      return (v<10)? fill+v : v;
    }

    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // console.log(data);
        //hue = (hue+.5) % 360;
        //setTheme(hue);

        // Update PRNDS display
        updateGearIndicator(data);
        // Update Speed displays
        updateSpeedDisplays(data);
		updateBoostDisplays(data);
		updateTachoDisplays(data);

        updateConsumption(data);
        appendGraphConsumption(data);
        //updateConsumption( Math.sin( hue*8*Math.PI/45)*600+300 );

        updateElectrics(data);
		
		
		const current_time = new Date(Date.now());
        text.time.text(fixClock(current_time.getHours()) + ":" + fixClock(current_time.getMinutes()));

        if (gForcesVisible === true) {
          updateAccelerometer(data);
        }
      }
    }

    //https://stackoverflow.com/a/56266358
    function isColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color !== "";
    }

    function parseColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color;
    }

    function getHue(rgb){
      let sep = rgb.indexOf(",") > -1 ? "," : " ";
      rgb = rgb.substr(4).split(")")[0].split(sep);

      for (let R in rgb) {
        let r = rgb[R];
        if (r.indexOf("%") > -1)
          rgb[R] = Math.round(r.substr(0,r.length - 1) / 100 * 255);
      }

      // Make r, g, and b fractions of 1
      let r = rgb[0] / 255,
          g = rgb[1] / 255,
          b = rgb[2] / 255;


      // Find greatest and smallest channel values
      let cmin = Math.min(r,g,b),
          cmax = Math.max(r,g,b),
          delta = cmax - cmin,
          h = 0,
          s = 0,
          l = 0;

      // Calculate hue
      // No difference
      if (delta == 0)
        h = 0;
      // Red is max
      else if (cmax == r)
        h = ((g - b) / delta) % 6;
      // Green is max
      else if (cmax == g)
        h = (b - r) / delta + 2;
      // Blue is max
      else
        h = (r - g) / delta + 4;

      h = Math.round(h * 60);

      // Make negative hues positive behind 360°
      if (h < 0)
          h += 360;
      return h;
    }

    $window.updateMode = (data) => {
      if(!ready){
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function(){ $window.updateMode(data) }, 100);
        return;
      }
      if(data === null
      || data === undefined
      || data.modeName === null
      || data.modeName === undefined
      || typeof data.modeName !== "string"
      || data.modeColor === null
      || data.modeColor === undefined
      || typeof data.modeColor !== "string"){
        console.error("updateMode receive wrong arguments :", data);
        document.getElementById("layer_wip").style.display = "inline";
        document.getElementById("tspan995").innerHTML = "MODE";
        return;
      }
      if(!isColor(data.modeColor)){
        console.error("This mode color is not in html format :",data.modeColor)
        return;
      }
      //console.log(data.modeColor);
      let h = getHue(parseColor(data.modeColor));
      setTheme(h);

      gForcesVisible = data.modeName != "Comfort";

      if (gForcesVisible === true) {
        consumGraph.root.css({opacity: 0});
        infoDisplay.infoValues.css({opacity: 0});
        consumGraph.graph_canvas.style.display = "none";
      }
      else {
        infoDisplay.accelerometer.css({opacity: 0});
        consumGraph.root.css({opacity: 1});
        consumGraph.graph_canvas.style.display = "inline";
        infoDisplay.infoValues.css({opacity: 1});
      }

    }
	ready = true;
    //$window.updateConsumption({current:0, average:0, range:0});
  });