--Thanks to TrackpadUser for the base code and aljowen for the smooth brake glow concept :3
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local speedCoef = nil
local startSpeed = nil
local unitCoef = nil

local smootherWheelspeed = nil
local smoother = newTemporalSigmoidSmoothing(500, 750, 500, 750, 0)


local function init(jbeamData)
	speedCoef = jbeamData.speedCoef or 1.0
	startSpeed = jbeamData.startSpeed or 100
	if jbeamData.speedUnit == "metric" then
		unitCoef = 3.6
	elseif jbeamData.speedUnit == "imperial" then
		unitCoef = 2.2369362920544
	else
		unitCoef = 3.6
	end
end

local function updateGFX(dt)

	smootherWheelspeed = smoother:get(electrics.values.wheelspeed, dt)

	if smootherWheelspeed < startSpeed/unitCoef then
		electrics.values.nonlinearspeed = smootherWheelspeed * unitCoef
	else
		electrics.values.nonlinearspeed = ((smootherWheelspeed * unitCoef) / speedCoef) + (startSpeed*speedCoef-startSpeed)/speedCoef
	end

end

M.init = init
M.updateGFX = updateGFX

return M
