--Thanks to TrackpadUser for the base code and aljowen for the smooth brake glow concept :3
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local brakeglow = nil
local htmlPath = nil
local rotorMaterial = nil

local updateTimer = 0
local updateFPS = 30
local invFPS = 1 / updateFPS 
local brakeGlow_rr = 0

local function init(jbeamData)
	brakeglow = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 256
	local height = jbeamData.textureHeight or 256
	rotorMaterial = jbeamData.rotorMaterial

    brakeGlow_rr = 0

    htmlTexture.create(brakeglow, htmlPath, width, height, updateFPS, "automatic")
	htmlTexture.call(brakeglow, "init", brakeGlow_rr)
end

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS then

  	if electrics.values.wheelThermals.RR then
		if rotorMaterial == "steel" then
			brakeGlow_rr = (electrics.values.wheelThermals.RR.brakeSurfaceTemperature - 450) / (1500 - 450) or 0
		end
		if rotorMaterial == "aluminum" then
			brakeGlow_rr =  0
		end
		if rotorMaterial == "carbon-ceramic" then
			brakeGlow_rr = (electrics.values.wheelThermals.RR.brakeSurfaceTemperature - 820) / (1800 - 820) or 0
		end
	end

    htmlTexture.call(brakeglow, "update", brakeGlow_rr)
    updateTimer = 0
  end
end

M.init = init
M.updateGFX = updateGFX

return M