--Thanks to TrackpadUser for the base code and aljowen for the smooth brake glow concept :3
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local brakeglow = nil
local htmlPath = nil
local rotorMaterial = nil

local updateTimer = 0
local updateFPS = 30
local invFPS = 1 / updateFPS 
local brakeGlow_rl = 0

local function init(jbeamData)
	brakeglow = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 256
	local height = jbeamData.textureHeight or 256
	rotorMaterial = jbeamData.rotorMaterial

    brakeGlow_rl = 0

    htmlTexture.create(brakeglow, htmlPath, width, height, updateFPS, "automatic")
	htmlTexture.call(brakeglow, "init", brakeGlow_rl)
end

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS then

  	if electrics.values.wheelThermals.RL then
		if rotorMaterial == "steel" then
			brakeGlow_rl = (electrics.values.wheelThermals.RL.brakeSurfaceTemperature - 450) / (1500 - 450) or 0
		end
		if rotorMaterial == "aluminum" then
			brakeGlow_rl =  0
		end
		if rotorMaterial == "carbon-ceramic" then
			brakeGlow_rl = (electrics.values.wheelThermals.RL.brakeSurfaceTemperature - 820) / (1800 - 820) or 0
		end
	end

    htmlTexture.call(brakeglow, "update", brakeGlow_rl)
    updateTimer = 0
  end
end

M.init = init
M.updateGFX = updateGFX

return M