angular.module("gaugesScreen", [])
  .controller("GaugesScreenController", function ($scope, $element, $window) {
    "use strict";
    var svg;
    var infoDisplay = {};
    var ready = false;
    var units = {
      uiUnitConsumptionRate: "metric",
      uiUnitDate: "ger",
      uiUnitEnergy: "metric",
      uiUnitLength: "metric",
      uiUnitPower: "hp",
      uiUnitPressure: "bar",
      uiUnitTemperature: "f",
      uiUnitTorque: "metric",
      uiUnitVolume: "l",
      uiUnitWeight: "kg"
    };

    $scope.onSVGLoaded = function () {
      svg = $element[0].children[0].children[0];

      infoDisplay.odo_mileage = hu("#odo_mileage_txt", svg);
      infoDisplay.odo_trip = hu("#odo_trip_txt", svg);
      infoDisplay.odo_unit = hu("#odo_unit_txt", svg);

      infoDisplay.hour = hu('#clock_hour_txt', svg);
      infoDisplay.min = hu('#clock_min_txt', svg);
      infoDisplay.climatEnvTemp = hu('#climat_env_temp_txt', svg);
      infoDisplay.climatSetTemp = hu('#climat_set_temp_txt', svg);

      infoDisplay.envTemp = hu('#env_temp_txt', svg);
      infoDisplay.fuel_avg = hu('#fuel_avg_txt', svg);
      infoDisplay.fuel_avg_icon_metric = hu('#fuel_avg_icon_metric', svg);
      infoDisplay.fuel_avg_icon_imperial = hu('#fuel_avg_icon_imperial', svg);

      infoDisplay.bg1 = hu('#bg1', svg);
      infoDisplay.bg2 = hu('#bg2', svg);
      infoDisplay.bg3 = hu('#bg3', svg);
      infoDisplay.bg4 = hu('#bg4', svg);


      ready = true;
    };

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (setupData) => {  
      for(let dk in setupData){
        if(typeof dk == "string" && dk.startsWith("uiUnit")){
          units[dk] = setupData[dk];
        }
      }
    }

    $window.updateElectrics = (data) => {

      let bgColor = (data.electrics.lowhighbeam===1)?"#1049F5":"#606B65";
      infoDisplay.bg1.css({"fill": bgColor});
      infoDisplay.bg2.css({"fill": bgColor});
      infoDisplay.bg3.css({"fill": bgColor});
      infoDisplay.bg4.css({"fill": bgColor});

      infoDisplay.hour.text(data.customModules.environmentData.time.split(":")[0])
      infoDisplay.min.text(data.customModules.environmentData.time.split(":")[1])

      let tmp = UiUnits.temperature(data.customModules.environmentData.temperatureEnv)
      infoDisplay.envTemp.text(tmp.val.toFixed(1) + tmp.unit);
      infoDisplay.climatEnvTemp.text(tmp.val.toFixed(0) + tmp.unit);
      if(tmp.unit === "°C")
        infoDisplay.climatSetTemp.text("22" + tmp.unit);
      else
        infoDisplay.climatSetTemp.text("72" + tmp.unit);

      tmp = UiUnits.consumptionRate(data.customModules.combustionEngineData.averageFuelConsumption*1e-5)
      if(tmp.val === "n/a" || data.electrics.wheelspeed < 4)
        infoDisplay.fuel_avg.text('--.-')
      else
      infoDisplay.fuel_avg.text(tmp.val.toFixed(1))

      infoDisplay.fuel_avg_icon_metric.n.style.display = (tmp.unit=="L/100km") ?"inline":"none";
      infoDisplay.fuel_avg_icon_imperial.n.style.display = (tmp.unit=="MPG") ?"inline":"none";

      if(data.electrics.odometer){
        let val = data.electrics.odometer
        val *= (units.uiUnitLength=="metric")?0.001:0.0006215;
        val = Math.min(999999,val);
        infoDisplay.odo_trip.text(val.toFixed(1))
        val += 84263
        val *= (units.uiUnitLength=="metric")?1:0.6215;
        infoDisplay.odo_mileage.text(val.toFixed(0))
        infoDisplay.odo_unit.text((units.uiUnitLength=="metric")?"km":"miles")
      }
    };

    $window.updateData = (data) => {
      if (data) {
        if (!ready) {
          console.log("not ready");
          return;
        }
        // Update Speed displays
        updateElectrics(data);
      }
    };
  });