-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local tag = 'smokebomb'
local smokeEnabled = false
local smokeNodes = {}

local function onInit()
    electrics.values.smokebomb = 0
	smokeEnabled = false
	
	for k, node in pairs (v.data.nodes) do
      if node.smokeEmiter == true then 
	    table.insert(smokeNodes, k) 
	  end
    end
	
end

local function updateGFX(dt)
    if electrics.values.smokebomb == 0 then
        beamstate.attachCouplers(tag)
    elseif electrics.values.smokebomb == 1 then
        beamstate.detachCouplers(tag)
    end
	
	if smokeEnabled then
	  for k, node in pairs (smokeNodes) do
        obj:addParticleByNodesRelative(node, node, 0, 49, 3, 2)
		obj:addParticleByNodesRelative(node, node, 0, 37, 3, 2)
      end
	end
	
end

local function onCouplerAttached(nodeId, obj2id, obj2nodeId)
    if v.data.nodes[nodeId].tag == "smokebomb" then
        --electrics.values.smokebomb = 1
		smokeEnabled = false
    end
end

local function onCouplerDetached(nodeId, obj2id, obj2nodeId)
    if v.data.nodes[nodeId].tag == "smokebomb" then
		--initial smoke burst
		obj:addParticleByNodesRelative(nodeId, nodeId, 0, 49, 1, 100)
		obj:addParticleByNodesRelative(nodeId, nodeId, 0, 37, 1, 100)
		smokeEnabled =  true
    end
end

-- public interface
M.onCouplerAttached = onCouplerAttached
M.onCouplerDetached = onCouplerDetached

M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M
