-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
--Mandatory controller parameters
M.type = "auxiliary"
M.relevantDevice = nil

local abs = math.abs
local min = math.min
local max = math.max

local barrelNodes = nil
local bulletTimer = nil
local numberOfRounds = nil
local roundIndex = nil
local gunState = nil
local desiredHandleValue = nil
local handleSmoother = newTemporalSmoothing(40, 60)
local fireRateTime = nil
local firingSound = nil

local bulletBeams = {}
local bulletNodes = {}
local activeBullets = {}
local ownID = obj:getID()

local breakBeam
local isBroken

local function updateGFX(dt)

  -- CHECKING IF GUN IS BROKEN --  
  if breakable then
    if isBroken then return end --if it's already broken, you can't do anything 
    local checkIfBroke = obj:beamIsBroken(breakBeam) --check if it just broke each frame
    if checkIfBroke then
      guihooks.message("Main gun broken", 10, "vehicle.damage") --notify the user ONLY ONCE that it just broke
	  isBroken =  true -- disable gun
	  for roundIndex = 1, 20, 1 do
		electrics.values["bllt_"..roundIndex] = nil --turn off the bullet thruster
	  end
	  electrics.values.recoil = 0
      return
    end
  end

  if gunState ~= "idle" or electrics.values.gun_fire >= 1 then --only go in here if we are STILL firing or want to fire
    bulletTimer = bulletTimer + dt

    if gunState == "idle" and electrics.values.gun_fire >= 1 and roundIndex <= numberOfRounds then --if we can fire, want to fire and still have rounds left...
	  obj:breakBeam(bulletBeams[roundIndex])		
      electrics.values["bllt_"..roundIndex] = 1 --roundIndex starts at 1, and determines which bullet is to be fired. it is added to "bllt_", so if roundIndex is 1 then the thruster with "bllt_1" as the control is activated
      electrics.values.recoil = 1 --activates the recoil thruster
      electrics.values.muzf = 1	--show the muzzleflash. This is done with glowmaps with "muzf" as their input.
      desiredHandleValue = 1
	  obj:createSFXSource2("/vehicles/t90m/tankgun.ogg", "AudioDefault3D", firingSound, barrelNodes[2], 0)
	  obj:playSFXOnceStaticCT(firingSound,barrelNodes[2], 5, 1, 1, 0)
      --sounds.playSoundOnceAtNode(firingSound, barrelNodes[2], 5)	--Play the firing sound
      obj:addParticleByNodesRelative(barrelNodes[2], barrelNodes[1], -500, 22, 0, 100)
	  obj:addParticleByNodesRelative(barrelNodes[2], barrelNodes[1], -5, 49, 1, 10)
      obj:addParticleByNodesRelative(barrelNodes[2], barrelNodes[1], -5, 29, 1, 10)
      obj:addParticleByNodesRelative(barrelNodes[2], barrelNodes[1], -5, 37, 1, 10)
      guihooks.message("Ammo: " .. numberOfRounds - roundIndex .. ", reload time " .. math.floor(fireRateTime) .. "s", fireRateTime, "tank") --updates the ammo counter
      gunState = "firing"

    elseif gunState == "firing" then
      if bulletTimer >= 0.06 then	--if the bullet timer goes over 0.03 seconds,
        electrics.values["bllt_"..roundIndex] = nil --turn off the bullet thruster
        electrics.values.recoil = 0 --turn of the recoil thruster
        electrics.values.muzf = 2 --hide muzzleflash
        desiredHandleValue = 0
        table.insert(activeBullets, {beamCid = bulletBeams[roundIndex], nodeCid = bulletNodes[roundIndex]})
        gunState = "fired"
      end

    elseif gunState == "fired" then
      if bulletTimer >= fireRateTime then --after x seconds since firing (this adjusts rate of fire),
        bulletTimer = 0	--reset bullet timer for next shot
        roundIndex = roundIndex + 1 --cycle "roundIndex". So if it was 1, it is now 2. When the code runs again, it will fire shell 2, then shell 3 and so on
        gunState = "idle"
      end
    end
  end
end

local function init(jbeamData)
  electrics.values.mg_barrel = 0
  electrics.values.gun_fire = 0
  electrics.values.recoil = 0
  
  for roundIndex = 1, 20, 1 do
    electrics.values["bllt_"..roundIndex] = nil --turn off the bullet thruster
  end
  
  bulletTimer = 0
  roundIndex = 1
  numberOfRounds = jbeamData.numberOfRounds or 0
  firingSound = jbeamData.firingSound or "CrashTestSound"
  fireRateTime = 1 / (jbeamData.rateOfFire or 1) 
  gunState = "idle"
  desiredHandleValue = 0

  breakable = jbeamData.breakable or false
  breakBeamName = jbeamData.breakBeamName or "turret"

  --get break beam cid
  for _,b in pairs(v.data.beams) do
	if b.name == breakBeamName then breakBeam = b.cid end
  end

  handleSmoother:reset()

  barrelNodes = {}
  bulletNodes = {}
  cameraNodes = {}
  
  for k, node in pairs (v.data.nodes) do
    if node.name == "gun_2" then barrelNodes[2] = k  end
    if node.name == "gun_12" then barrelNodes[1] = k  end	
    if node.bullet then bulletNodes[node.bullet] = k  end
  end

  activeBullets = {}
  bulletBeams = {}
  for k, beam in pairs(v.data.beams) do
    if beam.retainer then bulletBeams[beam.retainer] = k  end
  end
  
  isBroken = false
  
end

-- public interface
M.init = init
M.updateGFX = updateGFX
return M



