-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
-- based on welded
local M = {}
M.type = "auxilliary"
M.relevantDevice = "differential_R"

local differential = nil
local gearbox = nil

local inputAVSmoother = newExponentialSmoothing(10)
local outputAV1Smoother = newExponentialSmoothing(50)
local outputAV2Smoother = newExponentialSmoothing(50)
local outputTorque1Smoother = newExponentialSmoothing(50)
local outputTorque2Smoother = newExponentialSmoothing(50)
local gearReductionSmoother = newTemporalSmoothing(0.5,0.5)
local steeringSmoother = newTemporalSmoothing(2,2)

local function updateGFX(dt)

  local outputTorque1 = outputTorque1Smoother:get(differential.outputTorque1) --left wheel
  local outputTorque2 = outputTorque2Smoother:get(differential.outputTorque2) --right wheel
  local inputAV = inputAVSmoother:get(differential.inputAV)
  local inputGeared = inputAV * differential.invGearRatio
  local outputAV1 = outputAV1Smoother:get(differential.outputAV1) --left wheel
  local outputAV2 = outputAV2Smoother:get(differential.outputAV2) --right wheel
  local gearReduction = math.min(1 / math.abs(gearbox.gearIndex + 1e-30),1)
  local gearReductionSmoothed = gearReductionSmoother:getUncapped(gearReduction, dt)
  local powersign = clamp(inputAV * (outputTorque1 + outputTorque2),-1,1) --negative is engine braking
  local steering = steeringSmoother:getUncapped(electrics.values.steering_input, dt)
  --differential.diffTorqueSplitA = 0.5 + electrics.values.steering_input/2
  --differential.diffTorqueSplitB = 1 - differential.diffTorqueSplitA
  differential.outputAVBias = clamp(-steering * inputGeared * 2 * gearReductionSmoothed ^ 0.707,-16,16)
  --differential.outputAVBias = -electrics.values.steering_input * 10
  --log('I', "gearReductionSmoothed ", gearReductionSmoothed)
end

local function init(jbeamData)
  differential = powertrain.getDevice(jbeamData.transfercaseName)
  gearbox = powertrain.getDevice(jbeamData.gearboxName or "gearbox")

  if differential and gearbox then
    differential.outputAVBias = 0
    --differential.diffTorqueSplitA = 0.5
    --differential.diffTorqueSplitB = 0.5
    M.updateGFX = updateGFX

  end
end

M.init = init
M.reset = nop
M.updateGFX = nop

return M