-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}
M.type = "auxilliary"
M.relevantDevice = nil

local min = math.min
local max = math.max
local abs = math.abs
local leftWheel = nil
local rightWheel = nil
local turret = nil
local turret_rot_multiplier = nil

local function updateGFX(dt)

  electrics.values['turret_angle'] = math.min(1, math.max(-1.0, (electrics.values['turret_angle'] + electrics.values['turret_angle_input'] * dt)))

  local brakeR = min(max(electrics.values.brake_r, 0), 1)
  local brakeL = min(max(electrics.values.brake_l, 0), 1)

  if not rightWheel then return end
  if not leftWheel then return end
  if not turret then return end

  rightWheel.desiredBrakingTorque = 10*(rightWheel.brakeTorque * brakeR)
  leftWheel.desiredBrakingTorque = 10*(leftWheel.brakeTorque * brakeL)

  electrics.values.brake_r = electrics.values.brake
  electrics.values.brake_l = electrics.values.brake
  --if electrics.values.parkingbrake == 1 then
  -- electrics.values.brake_combined = 1
  --else
  -- electrics.values.brake_combined = electrics.values.brake
  --end

--  if electrics.values.brake_l > 0.5 or electrics.values.brake_r > 0.5 then
--    electrics.values.throttle = min(electrics.values.throttle, 0.7)
--  else
--  electrics.values.throttle = electrics.values.throttle
--  end

--  if electrics.values.brake == 1 then
--    electrics.values.brake_r =  1-(max(-electrics.values.steering_input/2, 0))
--    electrics.values.brake_l = 1-(max(electrics.values.steering_input/2, 0))
--  else
--   electrics.values.brake_r = (max(electrics.values.steering_input, 0))--* (max(electrics.values.throttle, 0.7))
--   electrics.values.brake_l = (max(-electrics.values.steering_input, 0))-- * (max(electrics.values.throttle, 0.7))
--  end

  if electrics.values.turretlock == 1 then
    turret.desiredBrakingTorque = 2500000
    electrics.values['turret_angle'] = 0
  else
    if electrics.values.turret_left == 0 and electrics.values.turret_right == 0 then
        turret.desiredBrakingTorque = 250000
    else
        turret.desiredBrakingTorque = 10000
    end
  end

  electrics.values.turret_alt = min(max(electrics.values.turret_alt + electrics.values.turret_updown_change * dt * 1, -1), 1)
  electrics.values.turret_altb = -electrics.values.turret_alt

end

local function init(jbeamData)
  electrics.values.brake_l = 0
  electrics.values.brake_r = 0
  electrics.values.brake_combined = 0
  electrics.values.turret_left = 0
  electrics.values.turret_angle = 0
  electrics.values.turret_angle_input = 0
  electrics.values.turret_right = 0
  electrics.values.turretlock = 0
  electrics.values.turret_alt = 0
  electrics.values.turret_altb = 0
  electrics.values.turret_updown_change = 0

  for _,wd in pairs(wheels.wheels) do
    if wd.name == "sprkt_R" then rightWheel = wd end
    if wd.name == "sprkt_L" then leftWheel = wd end
    if wd.name == "turret" then turret = wd end
  end

  turret_rot_multiplier = jbeamData.turret_rot_multiplier or 0.02

end

local function rotateTurret(value)
  electrics.values.turret_angle_input = turret_rot_multiplier * value --reduce rotation speed to prevent barrel wobble
end

M.init = init
M.updateGFX = updateGFX
M.update = update
M.rotateTurret = rotateTurret

return M