-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

--main variables
local agentygun_currentbullet_num
local agentygun_timeBetweenBullets
local agentygun_canShoot --boolean
local agentygun_bulletsLeft
local agentygun_bulletsLeftPercentage
local agentygun_breakBeam
local agentygun_isBroken --boolean
local agentygun_currentBeltSection_num
local agentygun_requiredBeltSectionLength
local agentygun_beltDetachBeam
local agentygun_isBeltDetached --boolean

--from jbeamData
local agentygun_ammo
local agentygun_shoot_delay
local agentygun_guntype
local agentygun_bulletMass
local agentygun_decreaseAmmoWeightOnShooting --boolean
local agentygun_bulletMassInAmmo
local agentygun_breakable --boolean
local agentygun_breakBeamName
local agentygun_hasBelt --boolean
local agentygun_bulletsPerBeltSection
local agentygun_beltDetachable --boolean
local agentygun_beltDetachBeamName
local agentygun_hasSecondaryGun --boolean
local agentygun_simplifiedMode --boolean

--variables for nodes
local agentygun_gunSoundNode --gun sounds location
local agentygun_fireParticleNodeInner --shoot particles location
local agentygun_fireParticleNodeOuter --shoot particles direction
local agentygun_ammoWeightStorageNode --stores the weight of the gun's ammo, more useful for flamethrower since the machine gun bullets are light
local agentygun_gunSoundNode2 --gun sounds location
local agentygun_fireParticleNodeInner2 --shoot particles location
local agentygun_fireParticleNodeOuter2 --shoot particles direction

--variables for names of the nodes from JbeamData
local agentygun_gunSoundNodeID
local agentygun_fireParticleNodeInnerID
local agentygun_fireParticleNodeOuterID
local agentygun_ammoWeightStorageNodeID
local agentygun_gunSoundNodeID2
local agentygun_fireParticleNodeInnerID2
local agentygun_fireParticleNodeOuterID2

local function init(jbeamData)

   agentygun_currentbullet_num = 1
   for k, node in pairs (v.data.nodes) do
	--reset particle properties
	node.horizontalVelocity = nil
	node.newHorizontalVelocity = nil
	node.exploded = nil
   end

  --get jbeamData
  agentygun_ammo = jbeamData.agentygun_ammo or 100
  agentygun_shoot_delay = jbeamData.agentygun_shoot_delay or 0.075
  agentygun_guntype = jbeamData.agentygun_guntype or "Machinegun"
  agentygun_bulletMass = jbeamData.agentygun_bulletMass or 2.5
  agentygun_gunSoundNodeID = jbeamData.agentygun_gunSoundNode or "agentygun2"
  agentygun_decreaseAmmoWeightOnShooting = jbeamData.agentygun_decreaseAmmoWeightOnShooting or false
  agentygun_fireParticleNodeInnerID = jbeamData.agentygun_fireParticleNodeInner or "agentygun2"
  agentygun_fireParticleNodeOuterID = jbeamData.agentygun_fireParticleNodeOuter or "agentygun1"
  agentygun_ammoWeightStorageNodeID = jbeamData.agentygun_ammoWeightStorageNode or "agentygun_ammo"
  agentygun_bulletMassInAmmo = jbeamData.agentygun_bulletMassInAmmo or 2.5
  agentygun_breakable = jbeamData.agentygun_breakable or false
  agentygun_breakBeamName = jbeamData.agentygun_breakBeamName or "agentygun_broken"
  agentygun_hasBelt = jbeamData.agentygun_hasBelt or false
  agentygun_bulletsPerBeltSection = jbeamData.agentygun_bulletsPerBeltSection or 10
  agentygun_beltDetachable = jbeamData.agentygun_beltDetachable or false
  agentygun_beltDetachBeamName = jbeamData.agentygun_beltDetachBeamName or "agentygun_belt_detach"
  agentygun_hasSecondaryGun = jbeamData.agentygun_hasSecondaryGun or false
  agentygun_gunSoundNodeID2 = jbeamData.agentygun_gunSoundNode2 or "agentygun2r"
  agentygun_fireParticleNodeInnerID2 = jbeamData.agentygun_fireParticleNodeInner2 or "agentygun2r"
  agentygun_fireParticleNodeOuterID2 = jbeamData.agentygun_fireParticleNodeOuter2 or "agentygun1r"
  agentygun_simplifiedMode = jbeamData.agentygun_simplifiedMode or false
  
  --reset electrics values for firing all bullets
  for i=1, agentygun_ammo, 1 do
    electrics.values["shootbullet_" .. i] = 0
  end
  
  --reset electrics values for belt control
  for i=1, (agentygun_ammo / agentygun_bulletsPerBeltSection + 1), 1 do
    electrics.values["agentygun_belt_" .. i] = 1
  end
  
  --reset other electrics
  electrics.values['agentygun_fire'] = 0
  electrics.values['agentygun_lifter'] = 0
  electrics.values['agentygun_lifter_input'] = 0
  
  --reset local variables
  agentygun_currentbullet_num = 1
  agentygun_timeBetweenBullets = 0
  agentygun_canShoot = true
  agentygun_isBroken = false
  agentygun_currentBeltSection_num = 1
  agentygun_requiredBeltSectionLength = 1
  agentygun_isBeltDetached = false
  
  --assign nodes to variables based on IDs from jbeamData
  for k, node in pairs (v.data.nodes) do
    if node.name == agentygun_gunSoundNodeID then agentygun_gunSoundNode = k  end
	if node.name == agentygun_fireParticleNodeInnerID then agentygun_fireParticleNodeInner = k  end
	if node.name == agentygun_fireParticleNodeOuterID then agentygun_fireParticleNodeOuter = k  end
	if node.name == agentygun_gunSoundNodeID2 then agentygun_gunSoundNode2 = k  end
	if node.name == agentygun_fireParticleNodeInnerID2 then agentygun_fireParticleNodeInner2 = k  end
	if node.name == agentygun_fireParticleNodeOuterID2 then agentygun_fireParticleNodeOuter2 = k  end
	--we need the cid here since we will be changing properties of the node itself
	if node.name == agentygun_ammoWeightStorageNodeID then agentygun_ammoWeightStorageNode = node.cid end
  end
  
  --get break beam cids
  for _,b in pairs(v.data.beams) do
	if b.name == agentygun_breakBeamName then agentygun_breakBeam = b.cid end
	if b.name == agentygun_beltDetachBeamName then agentygun_beltDetachBeam = b.cid end
  end
  
  --display GUI message based on gun type (this doesn't work sometimes for some reason)
  if agentygun_guntype == "flamethrower" then
    guihooks.message("Flamethrower fuel left: 100%", 5, "AgentY_gun")
  elseif agentygun_guntype == "machinegun" then
    if agentygun_hasSecondaryGun then
	  guihooks.message("Bullets left: " .. agentygun_ammo*2, 5, "AgentY_gun")
	else
	  guihooks.message("Bullets left: " .. agentygun_ammo, 5, "AgentY_gun")
	end
  end
   
end


local function updateGFX(dt) -- ms

  --FIRST WE MANAGE THE GUN LIFTING MECHANISM--
  electrics.values['agentygun_lifter'] = math.min(1, math.max(-1.0, (electrics.values['agentygun_lifter'] + electrics.values['agentygun_lifter_input'] * dt)))

  -- HIT PARTICLES (HELP WITH CODE BY AWESOMECARL) --
  if (agentygun_guntype == "Machinegun") then
	--track horizontal velocity for each fired node
	for k, node in pairs (v.data.nodes) do
	  --check if node is a bullet and then if it has been fired already
      if node.agentygun_bulletID and node.agentygun_bulletID <= agentygun_currentbullet_num - 1 then 
	  
	    --check if node had already emited particles
		if node.exploded == nil then

		  --mid air particles
		  obj:addParticleByNodesRelative(node.cid, node.cid, 10, 9, 0.02, 2)
	      obj:addParticleByNodesRelative(node.cid, node.cid, 10, 23, 0.02, 2)
	  
	      local velocity = vec3(obj:getNodeVelocityVector(node.cid))		
		  --check if node has just been fired (has no set velocity)
		  if node.newHorizontalVelocity == nil then
		    node.newHorizontalVelocity = (math.abs(velocity.x) + math.abs(velocity.y))
		  else
		    --update velocity, store old one in different variable
		    node.horizontalVelocity = node.newHorizontalVelocity
		    node.newHorizontalVelocity = (math.abs(velocity.x) + math.abs(velocity.y))	  
		    --check if node hit something - velocity has decreased significantly
		    if node.horizontalVelocity - node.newHorizontalVelocity > 0.1 then
		     
    		  --add particles once
			  obj:addParticleByNodesRelative(node.cid, node.cid, 12, 1, 0.02, 2)
			  obj:addParticleByNodesRelative(node.cid, node.cid, 15, 61, 0.02, 2)
			  obj:addParticleByNodesRelative(node.cid, node.cid, 10, 62, 0.02, 2)
			  obj:addParticleByNodesRelative(node.cid, node.cid, 20, 63, 0.02, 2)
			  obj:addParticleByNodesRelative(node.cid, node.cid, 8, 64, 0.02, 2)
			  obj:addParticleByNodesRelative(node.cid, node.cid, 12, 65, 0.02, 2)
			  obj:addParticleByNodesRelative(node.cid, node.cid, 10, 6, 0.02, 2)
			  node.exploded = true
			end
			
		  end		  
		end
	  end 	  
    end	

  end

  -- CHECKING IF GUN IS BROKEN --  
  if agentygun_breakable then
    if agentygun_isBroken then return end --if it's already broken, you can't do anything 
    local agentygun_checkIfBroke = obj:beamIsBroken(agentygun_breakBeam) --check if it just broke each frame
    if agentygun_checkIfBroke then
      guihooks.message(agentygun_guntype .. " broken", 10, "vehicle.damage") --notify the user ONLY ONCE that it just broke
	  agentygun_isBroken =  true -- disable gun
      return
    end
  end
  
  -- CHECKING IF BELT IS DETACHED --  
  if agentygun_beltDetachable then
	local agentygun_checkIfBeltDetached = obj:beamIsBroken(agentygun_beltDetachBeam) --check if it just broke each frame
	if agentygun_checkIfBeltDetached then
		guihooks.message("Ammo belt detached, no bullets!", 10, "vehicle.damage") --notify the user ONLY ONCE that it just broke
		agentygun_isBeltDetached =  true -- will act like it's trying to shoot but has no ammo
	end
  end
  
  -- CHECKING IF WE CAN SHOOT --
  agentygun_timeBetweenBullets = agentygun_timeBetweenBullets + dt --measure time between firing each bullet
  if agentygun_timeBetweenBullets < agentygun_shoot_delay then return end --can't shoot if timer is not over

  -- DETECTING INPUT --
  if electrics.values.agentygun_fire < 0.9 then return end --axis/button is not being pressed down far enough, ignore this event
  if agentygun_currentbullet_num > agentygun_ammo then return end -- don't shoot if we are out of ammo
  
  -- FIRING THE BULLETS --
  -- shoot bullet nr. agentygun_currentbullet_num, but only if the ammo belt is attached
  if agentygun_simplifiedMode then --less nodes, no thrusters, works on beam breaking, hopefully less lag
    if not agentygun_isBeltDetached then
	  for _,b in pairs(v.data.beams) do
	    if b.agentygun_bulletID == agentygun_currentbullet_num then 
		  obj:breakBeam(b.cid)
		end
	  end
	end
  else
	if not agentygun_isBeltDetached then electrics.values["shootbullet_" .. agentygun_currentbullet_num] = 1 end
  end
  agentygun_currentbullet_num = agentygun_currentbullet_num + 1 --go to next bullet in line
  agentygun_canShoot = false --disable shooting until time passes
  agentygun_timeBetweenBullets = 0 --reset timer
  agentygun_bulletsLeft = agentygun_ammo - agentygun_currentbullet_num + 1
  
  --Remove the weight of each node from the ammo storage weight
  if agentygun_decreaseAmmoWeightOnShooting == true then 
	local currentAmmoNodeMass = obj:getNodeMass(agentygun_ammoWeightStorageNode)
	local AmmoNodeMassAfterShooting = currentAmmoNodeMass - agentygun_bulletMassInAmmo
	obj:setNodeMass(agentygun_ammoWeightStorageNode, AmmoNodeMassAfterShooting)
  end
  
  --Now we have different behavior for different gun types
  
  if agentygun_guntype == "Flamethrower" then
    agentygun_bulletsLeftPercentage = agentygun_bulletsLeft / agentygun_ammo * 100 --display ammo as percentage of fuel left
    guihooks.message("Flamethrower fuel left: " .. agentygun_bulletsLeftPercentage .. "%", 5, "AgentY_gun") 
    --play fire sound
    obj:playSFXOnce("event:>Vehicle>Fire>Fire_Ignition", agentygun_gunSoundNode, 1, 1)	 
  
  elseif (agentygun_guntype == "Machinegun") and (agentygun_isBeltDetached == false) then
  
    if agentygun_hasSecondaryGun then
  
		guihooks.message("Bullets left: " .. agentygun_bulletsLeft*2, 5, "AgentY_gun")
		--play fire sound
		obj:playSFXOnce("CrashTestSound", agentygun_gunSoundNode, 1, 2)
		obj:playSFXOnce("CrashTestSound", agentygun_gunSoundNode2, 1, 2)
		--show firing particles
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 15, 61, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 10, 62, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 20, 63, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 8, 64, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 12, 65, 0, 1)
		--2
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner2, agentygun_fireParticleNodeOuter2, 15, 61, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner2, agentygun_fireParticleNodeOuter2, 10, 62, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner2, agentygun_fireParticleNodeOuter2, 20, 63, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner2, agentygun_fireParticleNodeOuter2, 8, 64, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner2, agentygun_fireParticleNodeOuter2, 12, 65, 0, 1)
		--show smoke
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 10, 6, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner2, agentygun_fireParticleNodeOuter2, 10, 6, 0, 1)
  
    else
  
		guihooks.message("Bullets left: " .. agentygun_bulletsLeft, 5, "AgentY_gun")
		--play fire sound
		obj:playSFXOnce("CrashTestSound", agentygun_gunSoundNode, 1, 2)
		--show firing particles
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 15, 61, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 10, 62, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 20, 63, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 8, 64, 0, 1)
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 12, 65, 0, 1)
		--show smoke
		obj:addParticleByNodesRelative(agentygun_fireParticleNodeInner, agentygun_fireParticleNodeOuter, 10, 6, 0, 1)
	
	end
	
	--increase weight of each bullet on the fly
	--this is not very realistic but it's the only way we can deal damage basically
	--it increases bullet energy and keeps momentum because it slows down bullets a bit
	--and if the bullets had this weight from the start, the vehicle wouldn't be able to hold the gun due to the weight
	for k, node in pairs (v.data.nodes) do
      if node.agentygun_bulletID == agentygun_currentbullet_num - 1 then 
	    obj:setNodeMass(node.cid, agentygun_bulletMass)
	    end 
    end	
	
	-- BELT ANIMATION --
	if (agentygun_hasBelt == true) and (agentygun_isBeltDetached == false) then
		--determine which section of the belt we are currently retracing based on the current bullet number
		agentygun_currentBeltSection_num = math.floor((agentygun_currentbullet_num - 2) / agentygun_bulletsPerBeltSection) + 1 --not sure why this works but it does lol 
		--retrace current section by a set amount
		agentygun_requiredBeltSectionLength = agentygun_requiredBeltSectionLength - (1 / agentygun_bulletsPerBeltSection)
		if agentygun_requiredBeltSectionLength < 0 then agentygun_requiredBeltSectionLength = agentygun_requiredBeltSectionLength + 1 end
		electrics.values["agentygun_belt_" .. agentygun_currentBeltSection_num] = agentygun_requiredBeltSectionLength - 1
	end
	
  end
  
end

local function liftGun(value)
  electrics.values.agentygun_lifter_input = value
end

-- public interface

M.init         = init
M.updateGFX    = updateGFX
M.liftGun      = liftGun

return M
