local M = {}

local wheelingMeasure = 0
local kickstand_kicked = 0
local back_stand

local particleType = 96 --BLOOD
local particleDuration = 200

local beamsNodesData = {}
local brokenBeams = {}


local HEAD = 1
local ARM_L = 2
local ARM_R = 3
local HIP_H = 4
local HIP_L = 5
local LEG_L = 6
local LEG_R = 7
local LAST_PART = 7

local GROUP = 1
local NODE = 2
local NODE_ID = 3
local COUNTER = 4
local BROKEN = 5

local MAX_WHEELING = 35
local MIN_LEAN = 30
local MAX_SPEED = 450

local MAX_LEAN = 55
local MAX_BALANCE_FORCE_SPIKE = 0.3
local lastBalanceForce = 0

local SPEED_ALGO_SWITCH = 999 --AKA not used
local MAX_LEAN_SPEED = 120

local steerPID
local leanPID
local wheeliePID



local function sign(n)
   return n > 0 and 1
      or  n < 0 and -1
      or  0
end

local function brokeBeamsCheck()
    
	for _, b in pairs(v.data.beams) do
		if obj:beamIsBroken(b.cid) and b.breakGroup == "fall" then return true
		end
	end
	return false
	
end

local function init(jbeamData)

	electrics.values["crouch_pose_req"] = 0
	electrics.values["rpmWarning"] = 0
	electrics.values["steeringBike"] = 0
	electrics.values["currentWheelingDistance"] = 0
	electrics.values["kickstand_retract"] = 0
	electrics.values["kickstand"] = 0
	electrics.values["downPressure"] =  0
	electrics.values["wheelie"] = 0
	electrics.values["toggle_wheelie"] = 0
	electrics.values["wheelerForce"] =  0
	lastBalanceForce = 0	
	back_stand = false

	lastPosition = 0
	timeSinceLastLog = 0
	kickstand_kicked = 0	
	particleDuration = (jbeamData.particleDuration / 0.05 ) or particleDuration
		
	--function newPIDParallel(kP, 		kI, 		kD, 		minOutput, 	maxOutput, integralInCoef, integralOutCoef, 	minIntegral, 					maxIntegral)
	steerPID = newPIDParallel(0.01, 	0.00001,	0.0020, 	-1.0, 		1.0, 			1.0, 				1.0, 					-1.0, 				1.0)
	wheeliePID = newPIDParallel(0.025, 	0.10000,	0.020, 		-1.0, 		1.0, 			1.0, 				1.0, 					-1.0, 				1.0)
	leanPID = newPIDParallel(0.015, 	0.0,		0.0030, 	-1.0, 		1.0, 			1.0, 				1.0, 					-1.0, 				1.0)
	
	for k, v in pairs(v.data.activeParts) do
		local partName = k
		if partName == "cyborg" then
			particleType = 1  --Electric 
		end
		if partName == "back_stand" then
			back_stand = true
		end
	end
		
	
	brokenBeams = {}

	beamsNodesData[HEAD] = {"bleeding", "tor_r11", 0, particleDuration, false}
	beamsNodesData[ARM_L] = {"bleeding", "l_a_h_3", 0, particleDuration, false}
	beamsNodesData[ARM_R] = {"bleeding", "r_a_h_3", 0, particleDuration, false}
	beamsNodesData[HIP_H] = {"bleeding", "tor_r6", 0, particleDuration, false}
	beamsNodesData[HIP_L] = {"bleeding", "hyp_h_r4", 0, particleDuration, false}
	beamsNodesData[LEG_L] = {"bleeding", "l_l_h_5", 0, particleDuration, false}
	beamsNodesData[LEG_R] = {"bleeding", "r_l_h_5", 0, particleDuration, false}
	

	for i=1,LAST_PART do
		if beamsNodesData[i] ~= nil then
			for _, node in pairs(v.data.nodes) do 
				if node.name == beamsNodesData[i][NODE] then
					beamsNodesData[i][NODE_ID] = node.cid
				end
			end
		end
	end
		
end



local function manageRiderParticles()
	for _, beam in pairs(v.data.beams) do 
		local beamBroken = obj:beamIsBroken(beam.cid)
		if beamBroken and brokenBeams[beam.cid] == nil then
			brokenBeams[beam.cid] = true
			
			if type(beam.breakGroup) == 'table' then
				for _, group in pairs(beam.breakGroup) do
					local stop = false
					for i=1,LAST_PART do
						if beamsNodesData[i][GROUP] == group and beamsNodesData[i][BROKEN] == false then
							beamsNodesData[i][BROKEN] = true
						end
					end
				end
			else				
				for i=1,LAST_PART do
					if beamsNodesData[i][GROUP] == beam.breakGroup and beamsNodesData[i][BROKEN] == false then
						beamsNodesData[i][BROKEN] = true
					end
				end
			end
		end
	end
		
	for i=1,LAST_PART do		
		if beamsNodesData[i][BROKEN] and beamsNodesData[i][COUNTER] > 0 then
			beamsNodesData[i][COUNTER] = beamsNodesData[i][COUNTER] - 1
			obj:addParticleByNodes(beamsNodesData[i][NODE_ID], beamsNodesData[i][NODE_ID], -1, particleType, 0.01, 5)
			--print("node " .. beamsNodesData[i][NODE] .. " bleeds")
		end
	end
end



local function getSpeedKmh()
	return wheels.wheels[0].wheelSpeed*3.6
end


local function limitMAXSpeed(speed)
	if speed > MAX_SPEED then
		electrics.values["throttle"] = 0
	end
end

local function manageAutoWheeling(dt)

	local pitchTarget = MAX_WHEELING
	local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
	local dirVectorRight = obj:getDirectionVectorRight()	--unit vector dir of ref->right
	local pitch = -dirVectorUp.y * dirVectorRight.x + dirVectorUp.x * dirVectorRight.y 	--cross product, only care about pitch, no z terms
	local truePitch = math.deg(math.asin(pitch))
	
	electrics.values["wheelerForce"] = wheeliePID:get(truePitch, pitchTarget, dt)

end

local function manageWheeling(trueLean, dt)

	if math.abs(trueLean) < (MAX_LEAN + 10) then 
		if electrics.values["wheelie"] == 1 then
			electrics.values["wheelerForce"] = 0.3
		else
			if electrics.values["toggle_wheelie"] == 1 then
				manageAutoWheeling(dt)
			else
				electrics.values["wheelerForce"] = 0
			end
		end
	else
		electrics.values["wheelerForce"] = 0
	end

--[[
	dump(string.format("WlF: %0.3f", 
		electrics.values["wheelerForce"]))
]]--
	
end
	
local function manageWheelingMeasure(dt)

	if electrics.values["wheeling_count"] == 1 then
		if wheelingMeasure == 0 then
			wheelingMeasure = 1 
			gui.message("Start measuring wheeling ...")
		end
	
		local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
		local dirVectorRight = obj:getDirectionVectorRight()	--unit vector dir of ref->left
		local wheeling = -dirVectorUp.y * dirVectorRight.x + dirVectorUp.x * dirVectorRight.y 	--cross product, only care about pitch, no x terms
		local trueWheeling = math.deg(math.asin(wheeling))
	
	
		if trueWheeling > 10 then
			local newPosition = obj:getPosition()
			local distance = math.sqrt( (newPosition.x - lastPosition.x) * (newPosition.x - lastPosition.x) + (newPosition.y - lastPosition.y) * (newPosition.y - lastPosition.y))
			local currentWheelingDistance = electrics.values["currentWheelingDistance"] + distance
			electrics.values["currentWheelingDistance"] = currentWheelingDistance
			lastPosition = obj:getPosition()
		else
			lastPosition = obj:getPosition()
		end
	end
	
	if electrics.values["wheeling_count"] == 0 then
		if wheelingMeasure == 1 then
			wheelingMeasure = 0 
			gui.message("Stop measuring wheeling ...")
		end
	end		
		
end

local function computeTrueLean()

	local dirVector = obj:getDirectionVector()		--unit vector direction of ref->back
	local dirVectorUp = obj:getDirectionVectorUp()	--unit vector dir of ref->up
	local lean = dirVectorUp.x * -dirVector.y + dirVectorUp.y * dirVector.x 	--cross product, only care about roll, no z terms
	local trueLean = math.deg(math.asin(lean))
	
	return trueLean

end


local function manageDownPressure(trueLean, speed)

	if 	math.abs(trueLean) < (MAX_LEAN + 10) and 
		(wheels.wheels[1].contactMaterialID1>0 or wheels.wheels[0].contactMaterialID1>0) and
		electrics.values["wheelie"] == 0 and
		electrics.values["toggle_wheelie"] == 0
		then
		electrics.values["downPressure"] = 1
	else
		electrics.values["downPressure"] = 0
	end
	
end

local function manageLeanHighSpeed(trueLean, speed, dt)
	
	local steering = electrics.values["steering_input"]

	local targetLean = -steering*MAX_LEAN
	
	local Kp = 0.01
	local Ki = 0.01
	local Kd = 0.0020
	
	Kp = 0.01*math.max(0.3, (1 - (speed/160)))
	Kd = 0.0020*math.max(0.3, (1 - (speed/160)))
	steerPID:setConfig(Kp, 	Ki,		Kd, 	-1.0, 		1.0, 			1.0, 				1.0, 					-1.0, 				1.0)
	
	
	if speed > 50 then
		targetLean = -steering*(MIN_LEAN + math.min((speed/MAX_LEAN_SPEED)*(MAX_LEAN - MIN_LEAN), (MAX_LEAN - MIN_LEAN))) --max lean angle is MAX_LEAN degrees
	else
		targetLean = -steering*MIN_LEAN
	end
				
	electrics.values["steering_adjusted"] = steerPID:get(trueLean, targetLean, dt)
end



local function manageLeanLowSpeed(trueLean, speed, dt)

	local targetLean = 0
	local steering = 0
	local balanceForce = 0
	local Kp = 0
	local Ki = 0
	local Kd = 0
	
	
	if math.abs(speed) < 1 then speed = 0 end
	
	--reduce steering input in function of speed
	if (speed >= 0 and speed < 50) or speed < 0 then
		steering = -electrics.values["steering_input"]
	else
		steering = -electrics.values["steering_input"]*(50/speed)
	end	
	
	electrics.values["steering_adjusted"] = -steering
	
	--R1 is FR for this bike
	if (math.abs(trueLean) < (MAX_LEAN + 10)) and (wheels.wheels[1].contactMaterialID1>0) then
		
		if speed < 3 and kickstand_kicked == 0 and back_stand == false then
			targetLean = 15
		else
			targetLean = (math.min(1, speed/20))*(-electrics.values["steering_input"])*MAX_LEAN*(electrics.values.reverse == 1 and -1 or 1)
		end

		Kp = 0.015*math.max(0.3, (1 - (speed/140)))
		--Kp = 0.0015*math.max(0.3, (1 - (speed/140))) with no rider
		

		--local Ki = 0.5*(steering ~=0 and 1 or 0.1/0.5) --math.min(1, speed/100)
		--local Ki = speed > 50 and (0.4*math.min(1, math.max(0.1/0.4, speed/130))*(steering ~=0 and 1 or 0.1/(0.4*math.min(1, math.max(0.1/0.4, speed/130))))) or 0.1
		--local Ki = 0.5*math.min(1, math.abs(targetLean-trueLean)/10)
		
		Kd = 0.0035*math.max(0.4, (1 - (speed/150)))
		--Kd = 0.0015*math.max(0.4, (1 - (speed/150))) with no rider

		
		if speed == 0 then
			Ki = 0.0001
			Kd = 0.001
			Kp = 0.007
		else
			if (speed > 0 and speed < 30) or speed < 0 then
				Ki = 0.0001
				Kd = 0.001
				Kp = 0.007
			else if (speed >=30 and speed < 50) then
					Ki = 0.1*math.min(1, speed/50)*(steering ~=0 and 1 or 0.1/(0.1*math.min(1, speed/50)))
				else if speed >= 50 and speed < 100 then
						Ki = 0.4*math.min(1, speed/100)*(steering ~=0 and 1 or 0.1/(0.4*math.min(1, speed/100)))
						Kd = 0.0040*math.max(0.8, (1 - (speed/100)))
					else if speed > 100 and speed < 370 then
							--Ki = 0.5*(steering ~=0 and 1 or 0.1/0.6)
							Ki = 0.7*(math.abs(steering) >=0 and math.max(0.1/0.7, math.abs(steering)) or 0.1/0.7)
						else -- >=370
							--Ki = 0.5*(steering ~=0 and 1 or 0.1/0.6)
							Ki = 0.5*(math.abs(steering) >=0 and math.max(0.1/0.5, math.abs(steering)) or 0.1/0.5)
							Kd = 0.0040
						end
					end
				end
			end
		end
				
		
		
	  --leanPID:setConfig(kP, 	kI, 	kD, 	minOutput, 	maxOutput, 		integralInCoef, 	integralOutCoef, 		minIntegral, 		maxIntegral)
		leanPID:setConfig(Kp, 	Ki,		Kd, 	-1.0, 		1.0, 			1.0, 				1.0, 					-1.0, 				1.0)
		
		balanceForce = leanPID:get(trueLean, targetLean, dt)*(steering ~=0 and math.max(1, speed/50) or 1)
		
		if math.abs(balanceForce - lastBalanceForce) >= MAX_BALANCE_FORCE_SPIKE then balanceForce=MAX_BALANCE_FORCE_SPIKE*sign(balanceForce) end
		
		lastBalanceForce = balanceForce
		
		electrics.values["balanceForceRL"] = balanceForce < 0 and -balanceForce or 0
		electrics.values["balanceForceLR"] = balanceForce > 0 and balanceForce or 0
		
		--[[
		dump(string.format("sp: %0.3f - TrL: %0.3f - TgL: %0.3f - bF: %0.3f", 
			speed,
			trueLean, 
			targetLean,
			balanceForce))
		]]--
				
	else

		electrics.values["balanceForceRL"] =  0
		electrics.values["balanceForceLR"] =  0

	end
	
	
	--dump(string.format("R0: %0.3f - R1: %0.3f",	wheels.wheels[0].contactMaterialID1, wheels.wheels[1].contactMaterialID1))
	
	--dump(string.format("sp:%0.4f - kp: %0.4f - ki: %0.4f - kd: %0.4f - bF: %0.4f - st: %0.4f", speed, Kp, Ki, Kd, balanceForce, electrics.values["steering_adjusted"]))
	
end

local function updateGFX(dt)

	local speed = getSpeedKmh()
	
	local trueLean = computeTrueLean()
	
	if electrics.values["rpmTacho"] > 10000	then
		electrics.values["rpmWarning"] = 1
	else
		electrics.values["rpmWarning"] = 0
	end


	----------
	limitMAXSpeed(speed)
	----------
	
	-------------
	manageWheelingMeasure(dt)
	-------------
	
	-------------
	manageWheeling(trueLean, dt)
	-------------
		
	--------------
	manageRiderParticles()
	--------------
	
	--------------
	manageDownPressure(trueLean, speed)
	--------------

	--------------------
	if speed > SPEED_ALGO_SWITCH then
		electrics.values["balanceForceRL"] =  0
		electrics.values["balanceForceLR"] =  0
		lastBalanceForce = 0	
		manageLeanHighSpeed(trueLean, speed, dt)
	else
		manageLeanLowSpeed(trueLean, speed, dt)
	end
	-------------	



	-------------
	--manage pose
	local pose = electrics.values["steering_input"] * 1.2
	if pose > 1 then
		pose=1
	else if pose < -1 then
		pose = -1
		end
	end
   
	electrics.values["driverPose"] = pose
	-------------	
	
	

	-------------	
	--Kickstand
	if kickstand_kicked == 0 then
		if speed > 3 or electrics.values["kickstand"] == 1 then 
			electrics.values["kickstand_retract"] = 1
			kickstand_kicked = 1
			for _, beam in pairs(v.data.beams) do 
				if beam.breakGroup == "back_stand_holder" then
					obj:breakBeam(beam.cid)
				end 
			end
		end
	end
	
	--------------
	--manage throttle if rider fell
	if brokeBeamsCheck() then
		electrics.values["throttle"] = 0
		electrics.values["steering_adjusted"] = 0
		electrics.values["balanceForceRL"] =  0
		electrics.values["balanceForceLR"] =  0
		electrics.values["downPressure"] =  0
		electrics.values["wheelerForce"] = 0
		lastBalanceForce = 0	
	end 
	--------------
	
	
	--------------	
	--Crouch
	if electrics.values["crouch_pose_req"] == 0 then
		if electrics.values["clutch_input"] == 1 then
			electrics.values["crouch_pose"] = 1
		else
			electrics.values["crouch_pose"] = 0
		end
	else
		electrics.values["crouch_pose"] = 1
	end
	--------------	


end


M.init      = init
M.updateGFX = updateGFX

return M