-- ALL CREDITS TO iRetr0x AND WarDaddyUSA
-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local multiplier = 0
local idlePress = 0

local function onInit()
   electrics.values.oilPress = 0
   electrics.values.oilPressWarn = 0
   --electrics.values.batterylight = 0
   electrics.values.rpmMax = electrics.values.rpmMax or 0
end

local function reset()
    onInit()
end

local function updateGFX(dt)
	if electrics.values.rpm < 300 then idlePress = (electrics.values.rpm * 0.001) else idlePress = 7.5 end
	multiplier = electrics.values.rpm * 0.0175
	electrics.values.batterylight = electrics.values.rpm < 200
	electrics.values.oilPress = (idlePress + (electrics.values.rpm * 0.022) - multiplier)
	electrics.values.oilPressWarn = electrics.values.oilPress < 10
	
	--electrics.values.rpmMax = electrics.values.rpm
	if electrics.values.rpm > electrics.values.rpmMax then 
	   electrics.values.rpmMax = electrics.values.rpm else
	   electrics.values.rpmMax = electrics.values.rpmMax
	end   
	if electrics.values.horn == 1 then electrics.values.rpmMax = 0 end
end

-- public interface
M.onInit    = onInit
M.onReset   = reset
M.updateGFX = updateGFX

return M