-- 模拟车辆电气系统中与行车灯相关的属性，这里简单用一个表来表示，你可以根据实际情况调整其初始值等
local electrics = {
    runninglight = 0,  -- 可以理解为行车灯相关的电量或者激活程度相关的值，初始设为0表示关闭
    electricalLoadCoef = 1  -- 电气负载系数，用于调整行车灯亮度计算等情况，初始设为1，可按需改变
}

-- 用于存储行车灯灯丝的状态信息，包括当前亮度、是否开启、目标亮度以及缓亮相关参数等
local runninglight_filament = {
    brightness = 0,  -- 当前亮度，初始为0即关闭状态
    isOn = false,  -- 是否开启
    targetBrightness = 0,  -- 目标亮度，开启时要达到的最终亮度
    step = 0.01,  -- 亮度增加步长，控制缓亮速度，数值越小缓亮越平滑，可根据实际需求调整
    smoother = {type = "temporalNonLinear", params = {8, 8}}  -- 模拟平滑器配置，类型和参数可按需修改
}

-- 函数用于更新行车灯灯丝的亮度，实现缓亮效果以及应用平滑器逻辑（这里简单模拟平滑效果）
function updateRunningLight()
    if runninglight_filament.isOn then
        -- 缓亮逻辑，按步长增加亮度，但不超过目标亮度
        runninglight_filament.brightness = math.min(runninglight_filament.brightness + runninglight_filament.step, runninglight_filament.targetBrightness)
        -- 模拟平滑器效果，根据设定的平滑器类型和参数对亮度进行调整，此处只是简单示例，实际可能更复杂
        if runninglight_filament.smoother.type == "temporalNonLinear" then
            local smoothParam1, smoothParam2 = unpack(runninglight_filament.smoother.params)
            runninglight_filament.brightness = runninglight_filament.brightness * (1 + (smoothParam1 / 100) * (1 - runninglight_filament.brightness)) * (1 - (smoothParam2 / 100) * runninglight_filament.brightness)
        end
        -- 这里可以添加代码，将更新后的亮度应用到实际游戏中的灯光显示上，例如通过游戏引擎的API设置灯光组件的亮度属性
        print("行车灯当前亮度: ", runninglight_filament.brightness)  -- 可打印查看亮度变化，实际中可去掉
    end
end

-- 函数用于开启行车灯，设置目标亮度并启动缓亮过程
function turnOnRunningLight(targetBrightness)
    runninglight_filament.isOn = true
    runninglight_filament.targetBrightness = targetBrightness
end

-- 函数用于关闭行车灯，重置亮度及相关参数
function turnOffRunningLight()
    runninglight_filament.isOn = false
    runninglight_filament.brightness = 0
    runninglight_filament.targetBrightness = 0
end

-- 以下是简单的测试代码示例
-- 开启行车灯，设置目标亮度为0.8
turnOnRunningLight(0.8)
-- 模拟游戏循环更新，这里简单循环多次查看亮度变化情况，实际中应结合游戏真实的时间更新机制
for _ = 1, 100 do
    updateRunningLight()
end
-- 关闭行车灯
turnOffRunningLight()