'use strict';
angular.module('beamng.apps')
.directive('sgrnanotriple7', ['$timeout', function ($timeout) {
  return {
    template: `
      <div style="width:100%;height:100%;position:relative;">
        <object id="nanoSvg"
                style="width:100%;height:100%;"
                type="image/svg+xml"
                data="/ui/modules/apps/sgrnanotriple7/sgrnanotriple7.svg">
        </object>
      </div>
    `,
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      const obj = element[0].querySelector('#nanoSvg');
      const streamsList = ['electrics'];
      if (typeof StreamsManager !== 'undefined') {
        StreamsManager.add(streamsList);
        scope.$on('$destroy', () => StreamsManager.remove(streamsList));
      }

      let lastStreams = { electrics: {} };

      function updateUI(doc) {
        if (!doc) return;
        const e = lastStreams.electrics || {};

        const sq1Border = doc.getElementById('square1-border');
        const sq1Bg = doc.getElementById('square1-bg');
        const sq2Border = doc.getElementById('square2-border');
        const sq2Bg = doc.getElementById('square2-bg');
        const sq3Border = doc.getElementById('square3-border');
        const sq3Bg = doc.getElementById('square3-bg');

        const defaultColor = '#ffffff';
        const greenColor   = '#39ff14';
        const blueColor    = '#1e90ff';

        const headlightsState = e.lights_state || 0;
        let headlightColor = defaultColor;
        if (headlightsState === 1) headlightColor = greenColor;
        if (headlightsState === 2) headlightColor = blueColor;

        if (sq1Border) sq1Border.setAttribute('stroke', headlightColor);
        if (sq1Bg) sq1Bg.setAttribute('fill', headlightColor);

        const fogOn = !!e.fog;
        const fogColor = fogOn ? greenColor : defaultColor;
        if (sq2Border) sq2Border.setAttribute('stroke', fogColor);
        if (sq2Bg) sq2Bg.setAttribute('fill', fogColor);

        const lightbarOn = !!e.lightbar;
        const lightbarColor = lightbarOn ? greenColor : defaultColor;
        if (sq3Border) sq3Border.setAttribute('stroke', lightbarColor);
        if (sq3Bg) sq3Bg.setAttribute('fill', lightbarColor);
      }

      function initSvg() {
        const doc = obj.contentDocument;
        if (!doc) return;

        const sq1 = doc.getElementById('square1');
        const sq2 = doc.getElementById('square2');
        const sq3 = doc.getElementById('square3');

        if (sq1) {
          sq1.style.cursor = 'pointer';
          sq1.addEventListener('click', () =>
            bngApi.activeObjectLua('electrics.toggle_lights()')
          );
        }
        if (sq2) {
          sq2.style.cursor = 'pointer';
          sq2.addEventListener('click', () =>
            bngApi.activeObjectLua('electrics.toggle_fog_lights()')
          );
        }
        if (sq3) {
          sq3.style.cursor = 'pointer';
          sq3.addEventListener('click', () =>
            bngApi.activeObjectLua('electrics.toggle_lightbar_signal()')
          );
        }

        updateUI(doc);
      }

      obj.addEventListener('load', () => $timeout(initSvg, 0));
      if (obj.contentDocument) $timeout(initSvg, 0);

      scope.$on('streamsUpdate', (_evt, streams) => {
        if (streams) lastStreams = streams;
        const doc = obj.contentDocument;
        if (doc) updateUI(doc);
      });
    }
  };
}]);
