'use strict';
angular.module('beamng.apps')
.directive('sgrnanotriple6', ['$timeout', function ($timeout) {
  return {
    template: `
      <div style="width:100%;height:100%;position:relative;">
        <object id="nanoSvg"
                style="width:100%;height:100%;"
                type="image/svg+xml"
                data="/ui/modules/apps/sgrnanotriple6/sgrnanotriple6.svg">
        </object>
      </div>
    `,
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      const obj = element[0].querySelector('#nanoSvg');
      const streamsList = ['electrics'];
      if (typeof StreamsManager !== 'undefined') {
        StreamsManager.add(streamsList);
        scope.$on('$destroy', () => StreamsManager.remove(streamsList));
      }

      let lastStreams = { electrics: {} };

      function updateUI(doc) {
        if (!doc) return;
        const e = lastStreams.electrics || {};

        const sq1Border = doc.getElementById('square1-border');
        const sq1Bg = doc.getElementById('square1-bg');
        const sq2Border = doc.getElementById('square2-border');
        const sq2Bg = doc.getElementById('square2-bg');
        const sq3Border = doc.getElementById('square3-border');
        const sq3Bg = doc.getElementById('square3-bg');

        const defaultColor = '#ffffff';
        const activeColor = '#ffff00';

        const leftOn = e.signal_L === 1;
        if (sq1Border) sq1Border.setAttribute('stroke', leftOn ? activeColor : defaultColor);
        if (sq1Bg) sq1Bg.setAttribute('fill', leftOn ? activeColor : defaultColor);

        const rightOn = e.signal_R === 1;
        if (sq2Border) sq2Border.setAttribute('stroke', rightOn ? activeColor : defaultColor);
        if (sq2Bg) sq2Bg.setAttribute('fill', rightOn ? activeColor : defaultColor);

        const hazardOn = e.hazard === 1;
        const hazardFlash = hazardOn && (e.signal_L === 1 || e.signal_R === 1);
        if (sq3Border) sq3Border.setAttribute('stroke', hazardFlash ? activeColor : defaultColor);
        if (sq3Bg) sq3Bg.setAttribute('fill', hazardFlash ? activeColor : defaultColor);
      }

      function initSvg() {
        const doc = obj.contentDocument;
        if (!doc) return;

        const sq1 = doc.getElementById('square1');
        const sq2 = doc.getElementById('square2');
        const sq3 = doc.getElementById('square3');

        if (sq1) {
          sq1.style.cursor = 'pointer';
          sq1.addEventListener('click', () =>
            bngApi.activeObjectLua('electrics.toggle_left_signal()')
          );
        }
        if (sq2) {
          sq2.style.cursor = 'pointer';
          sq2.addEventListener('click', () =>
            bngApi.activeObjectLua('electrics.toggle_right_signal()')
          );
        }
        if (sq3) {
  sq3.style.cursor = 'pointer';
  sq3.addEventListener('click', () =>
    bngApi.activeObjectLua('electrics.toggle_warn_signal()')
  );
}

        updateUI(doc);
      }

      obj.addEventListener('load', () => $timeout(initSvg, 0));
      if (obj.contentDocument) $timeout(initSvg, 0);

      scope.$on('streamsUpdate', (_evt, streams) => {
        if (streams) lastStreams = streams;
        const doc = obj.contentDocument;
        if (doc) updateUI(doc);
      });
    }
  };
}]);
