'use strict';
angular.module('beamng.apps')
.directive('sgrnanotriple5', ['$timeout', function ($timeout) {
  return {
    template: `
      <div style="width:100%;height:100%;position:relative;">
        <object id="nanoSvg"
                style="width:100%;height:100%;"
                type="image/svg+xml"
                data="/ui/modules/apps/sgrnanotriple5/sgrnanotriple5.svg">
        </object>
      </div>
    `,
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      const obj = element[0].querySelector('#nanoSvg');
      const streamsList = ['electrics'];
      if (typeof StreamsManager !== 'undefined') {
        StreamsManager.add(streamsList);
        scope.$on('$destroy', () => StreamsManager.remove(streamsList));
      }

      let lastStreams = { electrics: {} };

      function updateUI(doc) {
        if (!doc) return;
        const e = lastStreams.electrics || {};

        const sq1Border = doc.getElementById('square1-border');
        const sq2Border = doc.getElementById('square2-border');
        const sq3Border = doc.getElementById('square3-border');
        const sq1Bg = doc.getElementById('square1-bg');
        const sq2Bg = doc.getElementById('square2-bg');
        const sq3Bg = doc.getElementById('square3-bg');

        let stepOn = false;
        if (typeof e.isThreeStepMode !== 'undefined') {
          stepOn = !!e.isThreeStepMode;
        } else {
          stepOn = !!e.twoStep;
        }
        const stepColor = stepOn ? '#39ff14' : '#ff0000';
        if (sq1Border) sq1Border.setAttribute('stroke', stepColor);
        if (sq1Bg) sq1Bg.setAttribute('fill', stepColor);

        const nitrousOn = !!e.nitrousOxideArm || !!e.nitrousOxideActive;
        const nitrousColor = nitrousOn ? '#39ff14' : '#ff0000';
        if (sq2Border) sq2Border.setAttribute('stroke', nitrousColor);
        if (sq2Bg) sq2Bg.setAttribute('fill', nitrousColor);

        const ign = e.ignitionLevel || 0;
        let ignColor = '#ff0000';
        if (ign === 1) ignColor = '#ffff00';
        if (ign >= 2) ignColor = '#39ff14';
        if (sq3Border) sq3Border.setAttribute('stroke', ignColor);
        if (sq3Bg) sq3Bg.setAttribute('fill', ignColor);
      }

      function initSvg() {
        const doc = obj.contentDocument;
        if (!doc) return;

        const sq1 = doc.getElementById('square1');
        const sq2 = doc.getElementById('square2');
        const sq3 = doc.getElementById('square3');

        if (sq1) {
          sq1.style.cursor = 'pointer';
          sq1.addEventListener('click', () => {
            if (lastStreams.electrics && typeof lastStreams.electrics.isThreeStepMode !== 'undefined') {
              if (lastStreams.electrics.isThreeStepMode) {
                bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").cycleStepModeDown()');
              } else {
                bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").cycleStepModeUp()');
              }
            } else {
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").toggleTwoStep()');
            }
          });
        }
        if (sq2) {
          sq2.style.cursor = 'pointer';
          sq2.addEventListener('click', () =>
            bngApi.activeObjectLua('for _,v in pairs(controller.getControllersByType("nitrousOxideInjection")) do v.toggleActive() end')
          );
        }
        if (sq3) {
          sq3.style.cursor = 'pointer';
          sq3.addEventListener('mousedown', () =>
            bngApi.activeObjectLua('electrics.toggleIgnitionLevelOnDown()')
          );
          sq3.addEventListener('mouseup', () =>
            bngApi.activeObjectLua('electrics.toggleIgnitionLevelOnUp()')
          );
        }

        updateUI(doc);
      }

      obj.addEventListener('load', () => $timeout(initSvg, 0));
      if (obj.contentDocument) $timeout(initSvg, 0);

      scope.$on('streamsUpdate', (_evt, streams) => {
        if (streams) lastStreams = streams;
        const doc = obj.contentDocument;
        if (doc) updateUI(doc);
      });
    }
  };
}]);
