'use strict';
angular.module('beamng.apps')
  .directive('sgrnanotriple4', ['$timeout', function ($timeout) {
    return {
      template: `
        <div style="width:100%;height:100%;position:relative;">
          <object id="nanoSvg"
                  style="width:100%;height:100%;"
                  type="image/svg+xml"
                  data="/ui/modules/apps/sgrnanotriple4/sgrnanotriple4.svg">
          </object>
        </div>
      `,
      replace: true,
      restrict: 'EA',
      scope: true,
      link: function (scope, element) {
        const obj = element[0].querySelector('#nanoSvg');

        const streamsList = ['electrics'];
        if (typeof StreamsManager !== 'undefined') {
          StreamsManager.add(streamsList);
          scope.$on('$destroy', function () {
            StreamsManager.remove(streamsList);
          });
        }

        let lastStreams = { electrics: {} };

        function percentString(x) {
          return x == null ? '--' : `${Math.round(x * 100)}%`;
        }

        function updateUI(doc) {
          if (!doc) return;
          const s = lastStreams;

          const brake   = s.electrics && typeof s.electrics.brake === 'number'   ? s.electrics.brake   : null;
          const clutch  = s.electrics && typeof s.electrics.clutch === 'number'  ? s.electrics.clutch  : null;
          const throttle= s.electrics && typeof s.electrics.throttle === 'number'? s.electrics.throttle: null;

          const label1 = doc.getElementById('datalabel1');
          const data1  = doc.getElementById('data1');
          const alt1   = doc.getElementById('altdata1');
          if (label1) label1.textContent = 'Brake';
          if (data1)  data1.textContent  = percentString(brake);
          if (alt1)   alt1.textContent   = '';

          const label2 = doc.getElementById('datalabel2');
          const data2  = doc.getElementById('data2');
          const alt2   = doc.getElementById('altdata2');
          if (label2) label2.textContent = 'Clutch';
          if (data2)  data2.textContent  = percentString(clutch);
          if (alt2)   alt2.textContent   = '';

          const label3 = doc.getElementById('datalabel3');
          const data3  = doc.getElementById('data3');
          if (label3) label3.textContent = 'Throttle';
          if (data3)  data3.textContent  = percentString(throttle);
        }

        function initSvg() {
          const doc = obj.contentDocument;
          if (!doc) return;
          updateUI(doc);
        }

        obj.addEventListener('load', () => $timeout(initSvg, 0));
        if (obj.contentDocument) $timeout(initSvg, 0);

        scope.$on('streamsUpdate', function (_evt, streams) {
          if (streams) lastStreams = streams;
          const doc = obj.contentDocument;
          if (doc) updateUI(doc);
        });
      }
    };
  }]);
