'use strict';
angular.module('beamng.apps')
  .directive('sgrnanotriple2', ['$timeout', function ($timeout) {
    return {
      template: `
        <div style="width:100%;height:100%;position:relative;">
          <object id="nanoSvg"
                  style="width:100%;height:100%;"
                  type="image/svg+xml"
                  data="/ui/modules/apps/sgrnanotriple2/sgrnanotriple2.svg">
          </object>
        </div>
      `,
      replace: true,
      restrict: 'EA',
      scope: true,
      link: function (scope, element) {
        const obj = element[0].querySelector('#nanoSvg');

        const streamsList = ['electrics', 'sensors'];
        if (typeof StreamsManager !== 'undefined') {
          StreamsManager.add(streamsList);
          scope.$on('$destroy', function () {
            StreamsManager.remove(streamsList);
          });
        }

        let lastStreams = { electrics: {}, sensors: {} };

        function updateUI(doc) {
          if (!doc) return;
          const s = lastStreams;

          const label1 = doc.getElementById('datalabel1');
          const data1  = doc.getElementById('data1');
          const alt1   = doc.getElementById('altdata1');

          if (label1) label1.textContent = 'Boost';
          if (s.electrics && typeof s.electrics.boost === 'number') {
            if (data1) data1.textContent = Math.round(s.electrics.boost);
            if (alt1)  alt1.textContent  = 'psi';
          } else {
            if (data1) data1.textContent = '--';
            if (alt1)  alt1.textContent  = '';
          }

          const label2 = doc.getElementById('datalabel2');
          const data2  = doc.getElementById('data2');
          const alt2   = doc.getElementById('altdata2');

          if (label2) label2.textContent = 'Gear';
          if (data2) {
            const g = s.electrics && s.electrics.gear != null ? s.electrics.gear : '--';
            data2.textContent = g;
          }
          if (alt2) alt2.textContent = '';

          const label3 = doc.getElementById('datalabel3');
          const data3  = doc.getElementById('data3');

          if (label3) label3.textContent = 'RPM';
          if (data3) {
            const rpm = s.electrics && typeof s.electrics.rpm === 'number' ? Math.round(s.electrics.rpm) : '--';
            data3.textContent = rpm;
          }
        }

        function initSvg() {
          const doc = obj.contentDocument;
          if (!doc) return;
          updateUI(doc);
        }

        obj.addEventListener('load', () => $timeout(initSvg, 0));
        if (obj.contentDocument) $timeout(initSvg, 0);

        scope.$on('streamsUpdate', function (_evt, streams) {
          if (streams) lastStreams = streams;
          const doc = obj.contentDocument;
          if (doc) updateUI(doc);
        });
      }
    };
  }]);
