'use strict';
angular.module('beamng.apps')
  .directive('sgrnanotriple1', ['$timeout', function ($timeout) {
    return {
      template: `
        <div style="width:100%;height:100%;position:relative;">
          <object id="nanoSvg"
                  style="width:100%;height:100%;"
                  type="image/svg+xml"
                  data="/ui/modules/apps/sgrnanotriple1/sgrnanotriple1.svg">
          </object>
        </div>
        `,
      replace: true,
      restrict: 'EA',
      scope: true,
      link: function (scope, element) {
        const obj = element[0].querySelector('#nanoSvg');

        const streamsList = ['electrics'];
        if (typeof StreamsManager !== 'undefined') {
          StreamsManager.add(streamsList);
          scope.$on('$destroy', function () {
            StreamsManager.remove(streamsList);
          });
        }

        let lastStreams = { electrics: {} };

        function formatSpeed(mps) {
          if (mps == null) return { val: '--', unit: '' };
          try {
            const conv = UiUnits.speed(mps);
            return { val: Math.round(conv.val), unit: conv.unit };
          } catch {
            return { val: Math.round(mps * 3.6), unit: 'km/h' };
          }
        }

        function calcSlip(wheelMps, airMps) {
          if (wheelMps == null || airMps == null) return { val: '--', unit: '', pct: null };
          const diff = wheelMps - airMps;
          const conv = UiUnits.speed(Math.abs(diff));
          const sign = diff > 0 ? '+' : diff < 0 ? '-' : '';
          const pct = airMps !== 0 ? (diff / airMps) * 100 : null;
          return { val: sign + Math.round(conv.val), unit: conv.unit, pct: pct };
        }

        function updateUI(doc) {
          if (!doc) return;
          const s = lastStreams;

          const wheelMps = s.electrics && typeof s.electrics.wheelspeed === 'number' ? s.electrics.wheelspeed : null;
          const airMps   = s.electrics && typeof s.electrics.airspeed   === 'number' ? s.electrics.airspeed   : null;

          const wheelSpd = formatSpeed(wheelMps);
          const airSpd   = formatSpeed(airMps);
          const slip     = calcSlip(wheelMps, airMps);

          const label1 = doc.getElementById('datalabel1');
          const data1  = doc.getElementById('data1');
          const alt1   = doc.getElementById('altdata1');
          if (label1) label1.textContent = 'Wheel Speed';
          if (data1)  data1.textContent  = wheelSpd.val;
          if (alt1)   alt1.textContent   = wheelSpd.unit;

          const label2 = doc.getElementById('datalabel2');
          const data2  = doc.getElementById('data2');
          const alt2   = doc.getElementById('altdata2');
          if (label2) label2.textContent = 'Air Speed';
          if (data2)  data2.textContent  = airSpd.val;
          if (alt2)   alt2.textContent   = airSpd.unit;

          const label3 = doc.getElementById('datalabel3');
          const data3  = doc.getElementById('data3');
          if (label3) label3.textContent = 'Slip';
          if (data3) {
            data3.textContent = slip.val + (slip.unit ? ' ' + slip.unit : '');

            if (slip.pct != null) {
              if (slip.pct > 0 && slip.pct <= 10) {
                data3.setAttribute('fill', '#39ff14');
              } else if (slip.pct > 10 || slip.pct <= -5) {
                data3.setAttribute('fill', 'red');
              } else {
                data3.setAttribute('fill', 'white');
              }
            } else {
              data3.setAttribute('fill', 'white');
            }
          }
        }

        function initSvg() {
          const doc = obj.contentDocument;
          if (!doc) return;
          updateUI(doc);
        }

        obj.addEventListener('load', () => $timeout(initSvg, 0));
        if (obj.contentDocument) $timeout(initSvg, 0);

        scope.$on('streamsUpdate', function (_evt, streams) {
          if (streams) lastStreams = streams;
          const doc = obj.contentDocument;
          if (doc) updateUI(doc);
        });
      }
    };
  }]);
