'use strict';
angular.module('beamng.apps')
  .directive('sgrnanotriple0', ['$timeout', function ($timeout) {
    return {
      template: `
        <div style="width:100%;height:100%;position:relative;">
          <object id="nanoSvg"
                  style="width:100%;height:100%;"
                  type="image/svg+xml"
                  data="/ui/modules/apps/sgrnanotriple0/sgrnanotriple0.svg">
          </object>
        </div>
        `,
      replace: true,
      restrict: 'EA',
      scope: true,
      link: function (scope, element) {
        const obj = element[0].querySelector('#nanoSvg');

        const streamsList = ['electrics', 'engineThermalData'];
        if (typeof StreamsManager !== 'undefined') {
          StreamsManager.add(streamsList);
          scope.$on('$destroy', function () {
            StreamsManager.remove(streamsList);
          });
        }

        let lastStreams = { electrics: {}, engineThermalData: {} };

        function toF(c) {
          return (c * 9/5) + 32;
        }

        function updateUI(doc) {
          if (!doc) return;
          const e = lastStreams.electrics || {};
          const t = lastStreams.engineThermalData || {};

          const oilTemp = (typeof t.oilTemperature === 'number') ? toF(t.oilTemperature) : null;
          const label1 = doc.getElementById('datalabel1');
          const data1  = doc.getElementById('data1');
          const alt1   = doc.getElementById('altdata1');
          if (label1) label1.textContent = 'Oil Temp';
          if (data1)  data1.textContent  = oilTemp != null ? Math.round(oilTemp) : '--';
          if (alt1)   alt1.textContent   = oilTemp != null ? '°F' : '';

          const coolantTemp = (typeof t.coolantTemperature === 'number') ? toF(t.coolantTemperature) : null;
          const label2 = doc.getElementById('datalabel2');
          const data2  = doc.getElementById('data2');
          const alt2   = doc.getElementById('altdata2');
          if (label2) label2.textContent = 'Coolant Temp';
          if (data2)  data2.textContent  = coolantTemp != null ? Math.round(coolantTemp) : '--';
          if (alt2)   alt2.textContent   = coolantTemp != null ? '°F' : '';

          const load = (typeof e.engineLoad === 'number') ? e.engineLoad : null;
          const label3 = doc.getElementById('datalabel3');
          const data3  = doc.getElementById('data3');
          if (label3) label3.textContent = 'Load';
          if (data3) {
            data3.textContent = load != null ? Math.round(load * 100) + '%' : '--';
          }
        }

        function initSvg() {
          const doc = obj.contentDocument;
          if (!doc) return;
          updateUI(doc);
        }

        obj.addEventListener('load', () => $timeout(initSvg, 0));
        if (obj.contentDocument) $timeout(initSvg, 0);

        scope.$on('streamsUpdate', function (_evt, streams) {
          if (streams) lastStreams = streams;
          const doc = obj.contentDocument;
          if (doc) updateUI(doc);
        });
      }
    };
  }]);
