'use strict';
angular.module('beamng.apps')
.directive('sgrFt600metric', ['$timeout', function ($timeout) {
  return {
    template:
      `<div style="width: 100%; height: 100%; position: relative;">
        <object style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/sgrFt600metric/ft600metric.SVG"></object>
      </div>`,
    replace: true,
    restrict: 'EA',
    scope: {},
    link: function (scope, element) {
      scope.data = scope.data || {};
      let svg;
      let previousVoltsVal = 15.9;
      let voltageRampRate = 0.1;
      let previousIgnitionState = 0;
      let splashTriggered = false;
      const updateInterval = 50;
      let maxRPM = 8000;
      const idleFuelPressure = 60,
            maxRPMIncrease = 10,
            coldOilTempF = 70,
            warmOilTempF = 190,
            hotOilTempF = 250,
            coldOilPressure = 104,
            warmOilPressure = 73,
            hotOilPressure = 5,
            coldRPMPressureIncrease = 20,
            warmRPMPressureIncrease = 10,
            lowRPMThreshold = 500,
            nearZeroRPMThreshold = 25;
      let holdRPMWidth = 0;
      let holdTimestamp = Date.now();
      let holdingPeak = false;
      let previousTempRevLimiterRPM = null;
      let showRevLimiter = false;
      let revLimiterTimestamp = 0;
      let previousTwoStepState = null;
      let twoStepMessageActive = false;
      let twoStepMessageTimestamp = 0;
      const twoStepMessageDuration = 1000;
      function calculateRPMTicks(maxRPM, ripems) {
        let ticks = [];
        const maxTick = Math.floor(maxRPM / 1000);
        for (let i = 0; i <= maxTick; i++) {
          const xPos = 580 + (i * 1000 / maxRPM) * 2460;
          ticks.push({ label: i, x: xPos });
        }
        return ticks;
      }
      function injectFont() {
        let defs = svg.querySelector('defs');
        if (!defs) {
          defs = document.createElementNS("http://www.w3.org/2000/svg", "defs");
          svg.insertBefore(defs, svg.firstChild);
        }
        const styleElement = document.createElementNS("http://www.w3.org/2000/svg", "style");
        styleElement.textContent =
          `@font-face {
            font-family: 'DS-Digital';
            src: url('/ui/common/Arian LT Heavy.ttf') format('truetype');
          }
          @font-face {
            font-family: 'BlackLabel';
            src: url('/ui/common/blacklabel.ttf') format('truetype');
          }
          text {
            font-family: 'DS-Digital', sans-serif;
          }
          .blackLabelText {
            font-family: 'BlackLabel', sans-serif;
          }
          circle {
            transition: fill 40ms ease, r 40ms ease;
          }`;
        defs.appendChild(styleElement);
      }
      function injectBackground() {
        let bg = svg.getElementById('backgroundRect');
        if (!bg) {
          bg = document.createElementNS("http://www.w3.org/2000/svg", "rect");
          bg.setAttribute("id", "backgroundRect");
          bg.setAttribute("x", "0");
          bg.setAttribute("y", "0");
          bg.setAttribute("width", "100%");
          bg.setAttribute("height", "100%");
          bg.setAttribute("fill", "black");
          svg.insertBefore(bg, svg.firstChild);
        }
      }
      function calculateTiming(boost, tps, rpm) {
        const idleTiming = 12;
        const maxTiming = 40;
        const boostRetardPerPSI = 0.3;
        const tpsEffect = tps * 15;
        const rpmEffect = (rpm / 10000) * 13;
        let timing = idleTiming + tpsEffect + rpmEffect - (boost * boostRetardPerPSI);
        const randomVariation = Math.random() * 2 - 1;
        timing += randomVariation;
        return Math.max(10, Math.min(maxTiming, timing));
      }
      function calculateBatteryVoltage(rpm, maxRPM, ignitionState, dt) {
        let targetVoltsVal = 15.9;
        if (ignitionState === 3) {
          targetVoltsVal = 14.3;
        } else {
          if (rpm < 200) {
            targetVoltsVal = 15.9;
          } else {
            targetVoltsVal = rpm > 400 ? 15.7 : 15.0;
            const rpmProportion = Math.min(rpm / maxRPM, 1);
            targetVoltsVal -= 0.2 * rpmProportion;
            targetVoltsVal += (Math.random() * 0.4 - 0.2);
          }
        }
        if (previousVoltsVal < targetVoltsVal) {
          previousVoltsVal = Math.min(previousVoltsVal + voltageRampRate, targetVoltsVal);
        } else if (previousVoltsVal > targetVoltsVal) {
          previousVoltsVal = Math.max(previousVoltsVal - voltageRampRate, targetVoltsVal);
        }
        previousVoltsVal = Math.max(13.0, Math.min(previousVoltsVal, 16.0));
        return parseFloat(previousVoltsVal.toFixed(1));
      }
      let orbElems = [];
      function cacheOrbElements() {
        for (let i = 1; i <= 10; i++) {
          let orb = svg.getElementById('circle' + i);
          if (orb) {
            orbElems[i] = orb;
            orb.setAttribute('fill', 'url(#whiteGradient)');
            orb.setAttribute('r', '70');
          }
        }
      }
      function updateOrbs(currentRPM) {
        const rpmStart = 1000;
        const rpmEnd = maxRPM - 300;
        let orbThreshold = [];
        for (let i = 1; i <= 10; i++) {
          orbThreshold[i] = (i === 1) ? rpmStart : rpmStart + (i - 1) * (rpmEnd - rpmStart) / 9;
        }
        const orbOnGradients = {
          1: 'url(#greenGradient)', 2: 'url(#greenGradient)', 3: 'url(#greenGradient)',
          4: 'url(#redGradient)',   5: 'url(#redGradient)',   6: 'url(#redGradient)',
          7: 'url(#blueGradient)',  8: 'url(#blueGradient)',  9: 'url(#blueGradient)', 10: 'url(#blueGradient)'
        };
        for (let i = 1; i <= 10; i++) {
          if (currentRPM >= orbThreshold[i]) {
            orbElems[i].setAttribute('fill', orbOnGradients[i]);
            orbElems[i].setAttribute('r', '90');
          } else {
            orbElems[i].setAttribute('fill', 'url(#whiteGradient)');
            orbElems[i].setAttribute('r', '90');
          }
        }
      }
      function updateTwoStepLight(isActive) {
        const twoStepOrb = svg.getElementById('circle11');
        if (twoStepOrb) {
          if (isActive) {
            twoStepOrb.setAttribute('fill', 'url(#yellowGradient)');
            twoStepOrb.setAttribute('r', '90');
          } else {
            twoStepOrb.setAttribute('fill', 'url(#whiteGradient)');
            twoStepOrb.setAttribute('r', '70');
          }
        }
      }
      const streamsList = ['electrics', 'powertrainDeviceData', 'sensors', 'n2oInfo'];
      StreamsManager.add(streamsList);
      element[0].querySelector('object').addEventListener('load', function () {
        $timeout(function () {
          svg = element[0].querySelector('object').contentDocument;
          if (!svg) return;
          injectFont();
          injectBackground();
          cacheOrbElements();
          function blinkREC() {
            const recImg = svg.getElementById('REC');
            if (!recImg) return;
            recImg.style.opacity = (recImg.style.opacity === "1") ? "0" : "1";
            $timeout(blinkREC, 500);
          }
          blinkREC();
          scope.$on('streamsUpdate', function (event, data) {
            if (!data.electrics) return;
            const rpm = data.electrics.rpm || 0;
            const boost = data.electrics.boost || 0;
            const tps = data.electrics.throttle || 0;
            const gear = data.electrics.gear;
            const airspeed = data.electrics.airspeed || 0;
            const ignition = data.electrics.ignitionLevel;
            const oiltemp = data.electrics.oiltemp || 0;
            const ripems = data.electrics.ripems || rpm;
            if (data.electrics.maxrpm) {
              maxRPM = data.electrics.maxrpm;
            }
            const dt = updateInterval / 1000;
            const timing = calculateTiming(boost, tps, rpm);
            const voltsVal = calculateBatteryVoltage(rpm, maxRPM, ignition, dt);
            const rpmEl = svg.getElementById('rpmval');
            const gearEl = svg.getElementById('gearVal');
            const gpsSpeedEl = svg.getElementById('gpsSpeedval');
            const voltsEl = svg.getElementById('voltsval');
            const boostEl = svg.getElementById('Boostval');
            if (data.electrics.twoStep !== undefined) {
              if (previousTwoStepState === null || data.electrics.twoStep !== previousTwoStepState) {
                twoStepMessageActive = true;
                twoStepMessageTimestamp = Date.now();
                previousTwoStepState = data.electrics.twoStep;
              }
              updateTwoStepLight(data.electrics.twoStep);
            }
            const tempRevLimiterRPM = data.electrics.tempRevLimiterRPM;
            if (typeof tempRevLimiterRPM !== 'undefined') {
              if (previousTempRevLimiterRPM === null || tempRevLimiterRPM !== previousTempRevLimiterRPM) {
                showRevLimiter = true;
                revLimiterTimestamp = Date.now();
                previousTempRevLimiterRPM = tempRevLimiterRPM;
              }
            }
            let displayRPM = rpm;
            if (showRevLimiter) {
              if (Date.now() - revLimiterTimestamp < 1000) {
                displayRPM = tempRevLimiterRPM;
              } else {
                showRevLimiter = false;
              }
            }
            if (rpmEl) {
              if (twoStepMessageActive) {
                const twoStepText = data.electrics.twoStep ? "TwoStep: ON" : "TwoStep: OFF";
                while (rpmEl.firstChild) {
                  rpmEl.removeChild(rpmEl.firstChild);
                }
                const textTspan = document.createElementNS("http://www.w3.org/2000/svg", "tspan");
                textTspan.textContent = twoStepText;
                textTspan.setAttribute("font-size", "100");
                rpmEl.appendChild(textTspan);
                if (Date.now() - twoStepMessageTimestamp > twoStepMessageDuration) {
                  twoStepMessageActive = false;
                }
              } else {
                if (showRevLimiter) {
                  while (rpmEl.firstChild) { rpmEl.removeChild(rpmEl.firstChild); }
                  const prefixTspan = document.createElementNS("http://www.w3.org/2000/svg", "tspan");
                  prefixTspan.textContent = "TwoStep: ";
                  prefixTspan.setAttribute("font-size", "100");
                  const rpmTspan = document.createElementNS("http://www.w3.org/2000/svg", "tspan");
                  rpmTspan.textContent = Math.floor(displayRPM).toString();
                  rpmTspan.setAttribute("font-size", "100");
                  rpmEl.appendChild(prefixTspan);
                  rpmEl.appendChild(rpmTspan);
                } else {
                  rpmEl.textContent = Math.floor(displayRPM).toString();
                }
              }
            }
            if (gearEl) { gearEl.textContent = (gear === -1 ? 'R' : gear).toString(); }
            if (gpsSpeedEl) { gpsSpeedEl.textContent = Math.floor(airspeed * 3.6).toString(); }
            if (voltsEl) { voltsEl.textContent = voltsVal.toFixed(1); }
            if (boostEl) { boostEl.textContent = (boost / 14.5038).toFixed(2); }
            const rpmBarEl = svg.getElementById('rpmbar');
            if (rpmBarEl) {
              let rpmFraction = displayRPM / maxRPM;
              rpmFraction = Math.max(0, Math.min(1, rpmFraction));
              const mainRPMWidth = rpmFraction * 2610;
              rpmBarEl.setAttribute('width', mainRPMWidth);
              if (mainRPMWidth > holdRPMWidth) {
                holdRPMWidth = mainRPMWidth;
                holdTimestamp = Date.now();
                holdingPeak = true;
              } else if (mainRPMWidth < holdRPMWidth) {
                if (holdingPeak && (Date.now() - holdTimestamp < 3000)) {
                } else {
                  holdingPeak = false;
                  holdRPMWidth = mainRPMWidth;
                }
              }
              const holdRPMBarEl = svg.getElementById('rpmbar_hold');
              if (holdRPMBarEl) {
                holdRPMBarEl.setAttribute('width', holdRPMWidth);
              }
            }
            const tpsBarEl = svg.getElementById('tpsbar');
            if (tpsBarEl) {
              let tpsFraction = Math.max(0, Math.min(1, tps));
              tpsBarEl.setAttribute('width', tpsFraction * 838);
            }
            let oilTempF = (oiltemp * 1.8) + 32;
            let oilPressure = 0;
            if (oilTempF <= 70) {
              oilPressure = coldOilPressure + (ripems / 10000) * coldRPMPressureIncrease;
            } else if (oilTempF > 70 && oilTempF < 190) {
              const transitionFactor = (oilTempF - 70) / (190 - 70);
              const basePressure = coldOilPressure * (1 - transitionFactor) + warmOilPressure * transitionFactor;
              const rpmPressureIncrease = (ripems / 10000) * (coldRPMPressureIncrease * (1 - transitionFactor) + warmRPMPressureIncrease * transitionFactor);
              oilPressure = basePressure + rpmPressureIncrease;
            } else {
              oilPressure = warmOilPressure + ((oilTempF - warmOilTempF) / (hotOilTempF - warmOilTempF)) * (hotOilPressure - warmOilPressure) + (ripems / 10000) * warmRPMPressureIncrease;
            }
            if (ripems < lowRPMThreshold) {
              let pressureDropFactor = (ripems < nearZeroRPMThreshold) ? 0 : ripems / lowRPMThreshold;
              oilPressure *= pressureDropFactor;
            }
            if (ripems !== 0) oilPressure += Math.random() * 2 - 1;
            oilPressure = Math.max(0, oilPressure);
            const oilPressureBar = oilPressure / 14.5038;
            const oilpBarEl = svg.getElementById('oilpbar');
            if (oilpBarEl) {
              const minOilPressureBar = 0, maxOilPressureBar = 8;
              let oilPressureFraction = (oilPressureBar - minOilPressureBar) / (maxOilPressureBar - minOilPressureBar);
              oilPressureFraction = Math.max(0, Math.min(1, oilPressureFraction));
              let newOilpBarHeight = oilPressureFraction * 385;
              let newOilpBarY = 1325 - newOilpBarHeight;
              oilpBarEl.setAttribute('height', newOilpBarHeight);
              oilpBarEl.setAttribute('y', newOilpBarY);
              if (oilPressureBar >= (40 / 14.5038)) {
                oilpBarEl.setAttribute('fill', "#0edd0e");
              } else {
                let factor = oilPressureBar / (40 / 14.5038);
                let r = Math.round(255 * (1 - factor));
                let g = Math.round(255 * factor);
                oilpBarEl.setAttribute('fill', "rgb(" + r + "," + g + ",0)");
              }
            }
            let baseFuelPressure = idleFuelPressure + (Math.random() * 4 - 2);
            let rpmFuelPressure = (ripems / 10000) * maxRPMIncrease;
            if (ripems < lowRPMThreshold) {
              let pressureDropFactor = (ripems < nearZeroRPMThreshold) ? 0 : ripems / lowRPMThreshold;
              baseFuelPressure *= pressureDropFactor;
              rpmFuelPressure *= pressureDropFactor;
            }
            let fuelPressure = baseFuelPressure + rpmFuelPressure;
            let numericFuelPressure = fuelPressure + boost;
            const numericFuelPressureBar = numericFuelPressure / 14.5038;
            const fuelpBarEl = svg.getElementById('fuelpbar');
            if (fuelpBarEl) {
              const minFuelPressureBar = 0, maxFuelPressureBar = 12;
              let fuelPressureFraction = (numericFuelPressureBar - minFuelPressureBar) / (maxFuelPressureBar - minFuelPressureBar);
              fuelPressureFraction = Math.max(0, Math.min(1, fuelPressureFraction));
              let newFuelpBarHeight = fuelPressureFraction * 385;
              let newFuelpBarY = 1325 - newFuelpBarHeight;
              fuelpBarEl.setAttribute('height', newFuelpBarHeight);
              fuelpBarEl.setAttribute('y', newFuelpBarY);
              if (numericFuelPressureBar >= (55 / 14.5038)) {
                fuelpBarEl.setAttribute('fill', "#0edd0e");
              } else {
                let factor = numericFuelPressureBar / (55 / 14.5038);
                let r = Math.round(255 * (1 - factor));
                let g = Math.round(255 * factor);
                fuelpBarEl.setAttribute('fill', "rgb(" + r + "," + g + ",0)");
              }
            }
            let ticks = calculateRPMTicks(maxRPM, ripems);
            scope.data.rpmTicks = ticks;
            let ticksGroup = svg.getElementById('rpmTicksGroup');
            if (ticksGroup) {
              while(ticksGroup.firstChild) {
                ticksGroup.removeChild(ticksGroup.firstChild);
              }
              ticks.forEach(function(tick) {
                let textEl = document.createElementNS("http://www.w3.org/2000/svg", "text");
                textEl.setAttribute("x", tick.x);
                textEl.setAttribute("y", "388");
                textEl.setAttribute("font-size", "90");
                textEl.setAttribute("fill", "#ffffff");
                textEl.setAttribute("text-anchor", "middle");
                textEl.setAttribute("filter", "url(#glow)");
                textEl.textContent = tick.label;
                ticksGroup.appendChild(textEl);
              });
            }
            const splashEl = svg.getElementById('splashScreen');
            if (previousIgnitionState === 0 && (ignition === 1 || ignition === 3) && !splashTriggered) {
              if (splashEl) {
                splashEl.style.opacity = '1';
                splashTriggered = true;
                $timeout(function(){
                  splashEl.style.opacity = '0';
                }, 3000);
              }
            }
            if (ignition === 0) {
              splashTriggered = false;
            }
            previousIgnitionState = ignition;
            const blackoutEl = svg.getElementById('blackout');
            if (blackoutEl) {
              blackoutEl.style.display = (ignition <= 0.1) ? 'block' : 'none';
            }
            updateOrbs(rpm);
            if (data.sensors && svg) {
              const gx2 = data.sensors.gx2 || 0;
              const gy2 = data.sensors.gy2 || 0;
              const gravity = 9.81;
              let normX = gx2 / gravity;
              let normY = gy2 / gravity;
              let magnitude = Math.sqrt(normX * normX + normY * normY);
              if (magnitude > 2) {
                normX = normX * (2 / magnitude);
                normY = normY * (2 / magnitude);
              }
              const baseX = 974;
              const baseY = 734;
              const offsetScale = 150;
              const offsetX = normX * offsetScale;
              const offsetY = -normY * offsetScale;
              const gforceOrb = svg.getElementById('gforceorb');
              if (gforceOrb) {
                gforceOrb.setAttribute('cx', baseX + offsetX);
                gforceOrb.setAttribute('cy', baseY + offsetY);
              }
            }
            if (data.electrics) {
              const nitrousActive = data.electrics.nitrousOxideActive;
              const nitrousArmed = data.electrics.nitrousOxideArm;
              const circle13 = svg.getElementById('circle13');
              if (circle13) {
                if (nitrousActive) {
                  circle13.setAttribute('fill', 'url(#blueGradient)');
                  circle13.setAttribute('r', '90');
                } else if (nitrousArmed) {
                  circle13.setAttribute('fill', 'url(#greenGradient)');
                  circle13.setAttribute('r', '90');
                } else {
                  circle13.setAttribute('fill', 'url(#whiteGradient)');
                  circle13.setAttribute('r', '70');
                }
              }
            }
            if (data.electrics) {
              const transbrakeActive = data.electrics.transbrake;
              const circle12 = svg.getElementById('circle12');
              if (circle12) {
                if (transbrakeActive) {
                  circle12.setAttribute('fill', 'url(#redGradient)');
                  circle12.setAttribute('r', '90');
                } else {
                  circle12.setAttribute('fill', 'url(#whiteGradient)');
                  circle12.setAttribute('r', '70');
                }
              }
            }
            if (data.electrics) {
              const lockupClutchRatio = data.electrics.lockupClutchRatio || 0;
              const circle14 = svg.getElementById('circle14');
              if (circle14) {
                if (lockupClutchRatio > 0.99) {
                  circle14.setAttribute('fill', 'url(#pinkGradient)');
                  circle14.setAttribute('r', '90');
                } else {
                  circle14.setAttribute('fill', 'url(#whiteGradient)');
                  circle14.setAttribute('r', '70');
                }
              }
            }
          });
        }, 500);
      });
      scope.$on('$destroy', function () {
        StreamsManager.remove(streamsList);
      });
    }
  };
}]);
