'use strict';
angular.module('beamng.apps')
.directive('sgrDraggyTacho', ['$timeout', function ($timeout) {
  return {
    template: `
      <div style="width: 100%; height: 100%; position: relative;">
        <object id="tachSvg" style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/sgrdraggytacho/sgrdraggytacho.svg"></object>
      </div>
    `,
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      const objectElement = element[0].querySelector('object');
      const streamsList = ['electrics', 'engine', 'forcedInductionInfo', 'engineInfo'];
      StreamsManager.add(streamsList);

      let svg;
      let psiWedge;
      let rpmWedge;
      let maxRPM = 10000;
      let maxBoost = 100;
      let updateInterval;

      objectElement.addEventListener('load', function () {
        $timeout(function () {
          svg = objectElement.contentDocument;
          if (!svg) return;

          const boostGaugeWedge = document.createElementNS("http://www.w3.org/2000/svg", "path");
          boostGaugeWedge.setAttribute("fill", "rgba(50, 50, 50, 0.5)");
          boostGaugeWedge.setAttribute("d", describeWedge(33, 12, 12, 90, 45));
          svg.documentElement.insertBefore(boostGaugeWedge, svg.documentElement.firstChild);

          const staticPsiGaugeWedge = document.createElementNS("http://www.w3.org/2000/svg", "path");
          staticPsiGaugeWedge.setAttribute("fill", "rgba(50, 50, 50, 0.5)");
          staticPsiGaugeWedge.setAttribute("d", describeWedge(9, 22, 8, 90, 45));
          svg.documentElement.insertBefore(staticPsiGaugeWedge, svg.documentElement.firstChild);

          const largeCircle = svg.querySelector('circle[cx="33"][cy="12"][r="12"]');

          rpmWedge = document.createElementNS("http://www.w3.org/2000/svg", "path");
          rpmWedge.setAttribute("fill", "green");
          if (largeCircle && largeCircle.nextSibling) {
            svg.documentElement.insertBefore(rpmWedge, largeCircle.nextSibling);
          }

          psiWedge = document.createElementNS("http://www.w3.org/2000/svg", "path");
          psiWedge.setAttribute("fill", "green");

          const smallCircle = svg.querySelector('circle[cx="9"][cy="22"][r="8"]');
          if (smallCircle && smallCircle.nextSibling) {
            svg.documentElement.insertBefore(psiWedge, smallCircle.nextSibling);
          }

          const psiBoost = svg.getElementById('psiBoost');
          const gearElement = svg.getElementById('gear');
          const rpmVal = svg.getElementById('rpmval'); // New element for RPM value display

          if (!psiBoost || !gearElement || !rpmVal) return;

          scope.$on('streamsUpdate', function (event, streams) {
            if (svg && streams.electrics) {
              if (streams.engineInfo && streams.engineInfo.length > 1) {
                maxRPM = streams.engineInfo[1] || 16000;
              }

              if (streams.forcedInductionInfo && streams.forcedInductionInfo.maxBoost) {
                maxBoost = streams.forcedInductionInfo.maxBoost * 0.145038;
              }

              const boostPressure = streams.electrics.boost || 0;
              const boundedBoost = Math.min(Math.max(0, boostPressure), maxBoost);
              const boostForBar = boundedBoost.toFixed(1);
              const displayBoost = Math.floor(boundedBoost);
              psiBoost.textContent = displayBoost;

              const psiAngle = (boostForBar / maxBoost) * 270;
              psiWedge.setAttribute("d", describeWedge(9, 22, 8, psiAngle, 135));
              if (boundedBoost >= maxBoost * 0.9) {
                psiWedge.setAttribute("fill", "red");
              } else {
                psiWedge.setAttribute("fill", "green");
              }

              const rpm = streams.electrics.rpm || 0;
              const boundedRpm = Math.min(Math.max(0, Math.round(rpm)), maxRPM);
              const rpmAngle = (boundedRpm / maxRPM) * 270;

              if (boundedRpm >= maxRPM * 0.9) {
                rpmWedge.setAttribute("fill", "red");
              } else {
                rpmWedge.setAttribute("fill", "green");
              }

              rpmWedge.setAttribute("d", describeWedge(33, 12, 12, rpmAngle, 135));

              if (updateInterval) {
                $timeout.cancel(updateInterval); // Cancel the previous interval if it exists
              }

              function updateRpmValue() {
                rpmVal.textContent = boundedRpm;
                updateInterval = $timeout(updateRpmValue, 50); // Schedule the next update in 50ms
              }

              updateRpmValue();

              const gearValue = streams.electrics.gear;
              const displayGear = parseGearValue(gearValue);
              gearElement.textContent = displayGear;
            }
          });

          function describeWedge(cx, cy, radius, endAngle, startRotation) {
            const startX = cx + radius * Math.cos((startRotation) * (Math.PI / 180));
            const startY = cy + radius * Math.sin((startRotation) * (Math.PI / 180));
            const endX = cx + radius * Math.cos((endAngle + startRotation) * (Math.PI / 180));
            const endY = cy + radius * Math.sin((endAngle + startRotation) * (Math.PI / 180));
            const largeArcFlag = endAngle > 180 ? 1 : 0;

            return `M ${cx} ${cy} L ${startX} ${startY} A ${radius} ${radius} 0 ${largeArcFlag} 1 ${endX} ${endY} Z`;
          }

          function parseGearValue(gearValue) {
            if (typeof gearValue === 'string') {
              const match = gearValue.match(/^([A-Z]+)(\d*)$/);
              if (match) {
                const prefix = match[1];
                const number = match[2] || '';
                if (prefix === 'M' || prefix === 'S') {
                  return number || prefix;
                }
                return prefix;
              }
            } else if (typeof gearValue === 'number') {
              if (gearValue === -1) {
                return 'R';
              } else if (gearValue === 0) {
                return 'N';
              } else {
                return gearValue.toString();
              }
            }
            return '';
          }
        }, 500);
      });

      scope.$on('$destroy', function () {
        StreamsManager.remove(streamsList);
        if (updateInterval) $timeout.cancel(updateInterval); // Clear the interval on scope destruction
      });
    }
  };
}]);
