'use strict';
angular.module('beamng.apps')
.directive('sgrDraggySpeedo', ['$timeout', function ($timeout) {
  return {
    template: `
      <div style="width: 100%; height: 100%; position: relative;">
        <object id="tachSvg" style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/sgrdraggyspeedo/sgrdraggyspeedo.svg"></object>
      </div>
    `,
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      const objectElement = element[0].querySelector('object');
      const streamsList = ['electrics', 'sensors'];
      StreamsManager.add(streamsList);

      let svg;
      let totalDistance = 0;
      let lastUpdateTime = Date.now();
      const timerType = localStorage.getItem('timerType') || 'default';
      let targetDistance;

      if (timerType === 'eighthmile') {
        targetDistance = 660;
      } else if (timerType === 'quartermile') {
        targetDistance = 1320;
      } else if (timerType === 'everything') {
        targetDistance = 2640;
      } else {
        targetDistance = Infinity;
      }

      objectElement.addEventListener('load', function () {
        $timeout(function () {
          svg = objectElement.contentDocument;

          if (!svg) return;

          const speedText = svg.getElementById('speedText');
          const growingCircle = svg.getElementById('growingCircle');
          const gForceText = svg.getElementById('gForceText');
          const GgrowingCircle = svg.getElementById('GgrowingCircle');

          if (!speedText || !growingCircle || !gForceText || !GgrowingCircle) return;

          scope.$on('streamsUpdate', function (event, streams) {
            if (svg && streams.electrics) {
              const airspeedMps = streams.electrics.airspeed;
              const airspeedFeetPerSecond = airspeedMps * 3.28084;
              const currentTime = Date.now();
              const timeElapsed = (currentTime - lastUpdateTime) / 1000;
              lastUpdateTime = currentTime;

              if (timerType !== 'default') {
                totalDistance += airspeedFeetPerSecond * timeElapsed;
              }

              let fillProgress;
              if (timerType !== 'default') {
                fillProgress = Math.min(totalDistance / targetDistance, 1);
              } else {
                const currentSpeed = Math.round(UiUnits.speed(airspeedMps).val);
                fillProgress = Math.min(currentSpeed / 100, 1);
              }

              const boundedSpeed = Math.max(0, Math.round(UiUnits.speed(airspeedMps).val));
              speedText.textContent = boundedSpeed > 0 ? boundedSpeed : '0';

              if (boundedSpeed < 1) {
                totalDistance = 0;
                fillProgress = 0;
              }

              const initialRadius = 8;
              const maxRadius = 12;
              const newRadius = initialRadius + fillProgress * (maxRadius - initialRadius);

              growingCircle.setAttribute('r', newRadius);
              growingCircle.setAttribute('fill', fillProgress >= 1 ? 'red' : 'green');

              const gx2 = streams.sensors.gx2 || 0;
              const gy2 = streams.sensors.gy2 || 0;
              const gravity = 9.81;
              const currentGForce = Math.sqrt(gx2 * gx2 + gy2 * gy2) / gravity;

              gForceText.textContent = currentGForce.toFixed(2);

              const throttle = streams.electrics.throttle || 0;
              const gCircleColor = throttle <= 0.01 ? 'red' : (currentGForce >= 0 ? 'green' : 'orange');

              const initialGRadius = 5;
              const maxGRadius = 8;
              const newGRadius = Math.min(initialGRadius + (Math.abs(currentGForce) / 2) * (maxGRadius - initialGRadius), maxGRadius);
              GgrowingCircle.setAttribute('r', newGRadius);
              GgrowingCircle.setAttribute('fill', gCircleColor);
            }
          });

        }, 500);
      });

      scope.$on('$destroy', function () {
        StreamsManager.remove(streamsList);
      });
    }
  };
}]);
