'use strict';
angular.module('beamng.apps')
.directive('sgrEnviromentTemp', ['$timeout', function ($timeout) {
  return {
    template: `
      <div style="width: 100%; height: 100%; position: relative;">
        <object id="tachSvg" style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/sgrdraggyevniromenttemp/sgrdraggyevniromenttemp.svg"></object>
      </div>
    `,
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      const objectElement = element[0].querySelector('object');
      let currentTemp = parseInt(localStorage.getItem('draggyEnvironmentTemp')) || 72;

      objectElement.addEventListener('load', function () {
        const svgDoc = objectElement.contentDocument;
        const tempText = svgDoc.getElementById('temp');
        const clickableArea = svgDoc.getElementById('clickableArea');

        if (!tempText || !clickableArea) return;

        function updateTemperature() {
          tempText.textContent = currentTemp;
          localStorage.setItem('draggyEnvironmentTemp', currentTemp);
        }

        updateTemperature();

        clickableArea.addEventListener('mousedown', function(event) {
          if (event.button === 0) {
            currentTemp = Math.max(currentTemp - 1, 0);
          } else if (event.button === 2) {
            currentTemp++;
          }
          updateTemperature();
        });

      });

      scope.$on('$destroy', function () {});
    }
  };
}]);
