'use strict';
angular.module('beamng.apps')
.directive('sgrVolts', ['$log', '$timeout', function ($log, $timeout) {
  return {
    template: `
      <div style="width: 100%; height: 100%; position: relative;">
        <object id="svgObject" style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/SGRVolts/SGRVolts.svg"></object>
      </div>
    `,
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      element.css({ transition: 'opacity 0.3s ease' });
      let svg;
      let needle;
      let visible = false;
      let currentVoltage = 12;

      var streamsList = ['engineInfo'];
      StreamsManager.add(streamsList);

      element.find('object')[0].addEventListener('load', function () {
        svg = element.find('object')[0].contentDocument;

        if (!svg) {
          return;
        }

        needle = svg.getElementById('needle');

        if (!needle) {
          return;
        }

        function smoothTransition(targetVoltage, currentVoltage, smoothFactor) {
          return currentVoltage + (targetVoltage - currentVoltage) * smoothFactor;
        }

        function mapVoltageToRotation(voltage) {
          if (voltage <= 8) {
            return 169;
          } else if (voltage <= 10) {
            return 169 + ((voltage - 8) / (10 - 8)) * (178 - 169);
          } else if (voltage <= 12) {
            return 178 + ((voltage - 10) / (12 - 10)) * (196 - 178);
          } else if (voltage <= 14) {
            return 196 + ((voltage - 12) / (14 - 12)) * (222 - 196);
          } else if (voltage <= 16) {
            return 222 + ((voltage - 14) / (16 - 14)) * (240 - 222);
          } else if (voltage <= 18) {
            return 240 + ((voltage - 16) / (18 - 16)) * (250 - 240);
          } else {
            return 250;
          }
        }

        function calculateVoltage(rpm) {
          let voltage;
          if (rpm === 0) {
            voltage = 12.3;
          } else if (rpm > 0 && rpm <= 1000) {
            voltage = 13.8 + (0.4 * (rpm / 1000));
          } else if (rpm > 1000 && rpm <= 5000) {
            voltage = 14.2 + ((rpm - 1000) / 4000 * 0.6);
          } else {
            voltage = 14.8;
          }
          return voltage;
        }

        function updateNeedleRotation(rpm) {
          let targetVoltage = calculateVoltage(rpm);
          currentVoltage = smoothTransition(targetVoltage, currentVoltage, 0.05);
          let rotationDegree = mapVoltageToRotation(currentVoltage);
          needle.setAttribute('transform', `rotate(${rotationDegree}, 1, 60)`);
        }

        scope.$on('streamsUpdate', function (event, streams) {
          if (svg && needle) {
            let rpm = streams.engineInfo[4];
            updateNeedleRotation(rpm);
            if (!visible) {
              element[0].style.opacity = 1;
              visible = true;
            }
          }
        });

        scope.$on('$destroy', function () {
          StreamsManager.remove(streamsList);
        });
      });
    }
  };
}]);
