'use strict';
angular.module('beamng.apps')
.directive('sgrCoolant', ['$log', '$timeout', function ($log, $timeout) {
  return {
    template: `
      <div style="width: 100%; height: 100%; position: relative;">
        <object style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/SGRCoolant/SGRCoolant.svg"></object>
      </div>
    `,
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      element.css({ transition: 'opacity 0.3s ease' });
      let svg;
      let visible = false;

      element[0].querySelector('object').addEventListener('load', function () {
        $timeout(function () {
          svg = element[0].querySelector('object').contentDocument;

          if (!svg) {
            return;
          }

          let needle = svg.getElementById('needle');

          if (!needle) {
            return;
          }

          function updateNeedleRotation(temp) {
            let rotationDegree;

            if (temp >= 55 && temp <= 60) {
              rotationDegree = -280 + ((temp - 55) / (60 - 55)) * (-268 + 280);
            } else if (temp > 60 && temp <= 71) {
              rotationDegree = -268 + ((temp - 60) / (71 - 60)) * (-252 + 268);
            } else if (temp > 71 && temp <= 82) {
              rotationDegree = -252 + ((temp - 71) / (82 - 71)) * (-227 + 252);
            } else if (temp > 82 && temp <= 93) {
              rotationDegree = -227 + ((temp - 82) / (93 - 82)) * (-199 + 227);
            } else if (temp > 93 && temp <= 104) {
              rotationDegree = -199 + ((temp - 93) / (104 - 93)) * (-169 + 199);
            } else if (temp > 104 && temp <= 116) {
              rotationDegree = -169 + ((temp - 104) / (116 - 104)) * (-127 + 169);
            } else if (temp > 116 && temp <= 127) {
              rotationDegree = -127 + ((temp - 116) / (127 - 116)) * (-76 + 127);
            } else if (temp > 127 && temp <= 137) {
              rotationDegree = -76 + ((temp - 127) / (137 - 127)) * (-20 + 76);
            } else {
              rotationDegree = (temp < 55) ? -280 : -20;
            }

            needle.setAttribute('transform', `rotate(${rotationDegree}, 1, -20)`);
          }

          scope.$on('streamsUpdate', function (event, data) {
            if (svg && needle) {
              let coolantTemp;

              if (data.engineThermalData && data.engineThermalData.coolantTemperature !== undefined) {
                coolantTemp = data.engineThermalData.coolantTemperature;
              } else if (data.electrics && data.electrics.watertemp !== undefined) {
                coolantTemp = data.electrics.watertemp;
              }

              if (coolantTemp !== undefined) {
                updateNeedleRotation(coolantTemp);
              }

              if (!visible) {
                element[0].querySelector('object').style.opacity = 1;
                visible = true;
              }
            }
          });
        }, 500);
      });

      scope.$on('$destroy', function () {
        if (svg && svg.getStreams) StreamsManager.remove(svg.getStreams());
      });
    }
  };
}]);
