angular.module('beamng.stuff')

.directive('animatedIcon', [function () {
  return {
    template: '<div class="icon" layout-align="center center"><img class="iconImg"></div>',
    replace: true,
    restrict: 'EA',
    link: function (scope, element, attrs) {
      scope.$watch('data', function() {
        element[0].querySelector('img').src = "/ui/modules/loading/icon_" + attrs.icon + ".svg"
        if(scope.data !== undefined) {
          let percent = scope.data.iconState[attrs.icon.toUpperCase()] || 0
          element[0].style.backgroundPosition = '0 ' + (percent)  + '%'
        }
      })
    }
  }
}])

.directive('animatedProgressBar', [function () {
  return {
    template: '<div class="progressBarBackground" layout="column" layout-align="center center"><div class="progressBarForeground" layout="column" layout-align="center end"></div><div class="progressBarPercentText"></div></div>',
    replace: true,
    restrict: 'EA',
    link: function (scope, element, attrs) {
      scope.$watch('data', function() {
        let pr = element[0].querySelector('.progressBarForeground')
        let prText = element[0].querySelector('.progressBarPercentText')
        if(scope.data !== undefined) {
          if(scope.data.currentEntries.length > 0) {
            let p = scope.data.currentEntries[0].progress
            pr.style.left = '-' + (100 - p)  + '%'
            prText.innerHTML = Math.round(p)  + '%'
          } else {
            pr.style.left = '0'
            prText.innerHTML = ''
          }
        }
      })
    }
  }
}])

.directive('animatedProgressStatus', [function () {
  return {
    template: '<div class="progressStatus" layout-align="center center"></div>',
    replace: true,
    restrict: 'EA',
    link: function (scope, element, attrs) {
      scope.$watch('data', function() {
        if(scope.data !== undefined) {
          if(scope.data.currentEntries.length > 0) {
            element[0].innerHTML = scope.data.currentEntries[0].message
          } else {
            element[0].innerHTML = ''
          }
        }
      })
    }
  }
}])

.controller('LoadingController', ['$scope', 'ControlsUtils', 'Hints', 'Utils', function ($scope, ControlsUtils, Hints, Utils) {
  let vm = this
  $scope.hintTranslationKey = Hints[Math.floor(Math.random() * Hints.length)]

  function updateData(data) {
    $scope.data = {}
    $scope.data.historyEntries = data.historyEntries
    $scope.data.historyEntriesDisplay = data.historyEntries.slice(Math.max(data.historyEntries.length - 3, 1))
    $scope.data.currentEntries = data.currentEntries
    $scope.data.iconState = {}
    for(let i = 0; i < data.currentEntries.length; i++) {
      $scope.data.iconState[data.currentEntries[i].name.toUpperCase()] = data.currentEntries[i].progress
    }
    for(let i = 0; i < data.historyEntries.length; i++) {
      $scope.data.iconState[data.historyEntries[i].name.toUpperCase()] = 100
    }
  }

  $scope.$on('UpdateLoadingProgressV2', function (event, data) {
    window.requestAnimationFrame(function () {
      $scope.$apply(function () {
        updateData(data)
      })
    })
    $scope.$digest()
  })

  bngApi.engineLua('sailingTheHighSeas', (val) => {
    $scope.sailingTheHighSeas = val
  })

  let AMOUNT_OF_LOADING_IMAGES = 1
  let rnd = Utils.random(1, AMOUNT_OF_LOADING_IMAGES, true)
  let file = `/ui/modules/loading/background/${beamng.product}/drive_loading_${rnd}.png`
  if ($scope.sailingTheHighSeas === true) {
    file = "/ui/modules/mainmenu/unofficial_version.jpg"
  }
  $scope.$evalAsync(() => {
    vm.img = file
    setTimeout(function () {
      let a = new Image()
      a.onload = function () {
        Utils.waitForCefAndAngular(() => {
          bngApi.engineLua('core_gamestate.loadingScreenActive()')
        })
      }
      a.src = file
    })
  })

  let timeout = setTimeout(() => bngApi.engineLua('core_gamestate.loadingScreenActive()'), 10000)

  $scope.$on('$destroy', function () {
    clearTimeout(timeout)
  })
}])
