local M = {}

local lightsPDState = 0
local flashingLEDsOn = nil
local flashDuration = 0
local flashTimer = 0
local flashSwitch = false

local function onInit()
    electrics.values['RPM_led1'] = 0
    electrics.values['RPM_led2'] = 0
    electrics.values['RPM_led3'] = 0
    electrics.values['RPM_led4'] = 0
    electrics.values['RPM_led5'] = 0
    electrics.values['RPM_led6'] = 0
    electrics.values['RPM_led7'] = 0
    electrics.values['RPM_led8'] = 0
    electrics.values['RPM_led9'] = 0


    flashDuration = 0.3
    flashTimer = 0
    flashSwitch = false

    flashingLEDsOn = {
        'RPM_led1', 'RPM_led2', 'RPM_led3', 'RPM_led4', 'RPM_led5', 'RPM_led6', 'RPM_led7',
        'RPM_led8', 'RPM_led9'
    }
end

local function onReset()
    onInit()
end

local function updateGFX(dt)
    if electrics.values['rpm'] > 6000 and electrics.values['rpm'] < 12000 then
       electrics.values['RPM_led1'] = 1
    else
       electrics.values['RPM_led1'] = 0
    end

    if electrics.values['rpm'] > 6175 and electrics.values['rpm'] < 12000 then
       electrics.values['RPM_led2'] = 1
    else
       electrics.values['RPM_led2'] = 0
    end

    if electrics.values['rpm'] > 6350 and electrics.values['rpm'] < 12000 then
       electrics.values['RPM_led3'] = 1
    else
       electrics.values['RPM_led3'] = 0
    end

    if electrics.values['rpm'] > 6525 and electrics.values['rpm'] < 12000 then
       electrics.values['RPM_led4'] = 1
    else
       electrics.values['RPM_led4'] = 0
    end

    if electrics.values['rpm'] > 6700 and electrics.values['rpm'] < 12000 then
       electrics.values['RPM_led5'] = 1
    else
       electrics.values['RPM_led5'] = 0
    end

    if electrics.values['rpm'] > 6875 and electrics.values['rpm'] < 12000 then
       electrics.values['RPM_led6'] = 1
    else
       electrics.values['RPM_led6'] = 0
    end

    if electrics.values['rpm'] > 7050 and electrics.values['rpm'] < 12000 then
       electrics.values['RPM_led7'] = 1
    else
       electrics.values['RPM_led7'] = 0
    end

    if electrics.values['rpm'] > 7250 and electrics.values['rpm'] < 12000 then
       electrics.values['RPM_led8'] = 1
    else
       electrics.values['RPM_led8'] = 0
    end

    if electrics.values['rpm'] > 7500 and electrics.values['rpm'] < 12000 then
       electrics.values['RPM_led9'] = 1
    else
       electrics.values['RPM_led9'] = 0
    end

    if electrics.values['rpm'] < 500 then
       electrics.values['RPM_ledoff'] = 1
    else
       electrics.values['RPM_ledoff'] = 0
    end

    flashTimer = flashTimer - dt
    if electrics.values['rpm'] > 7500 and electrics.values['rpm'] < 12000 then
        if flashTimer <= 0 then
            flashSwitch = not flashSwitch
            flashTimer = flashDuration
        end

        local flashValue = flashSwitch and 1 or 0
        for _, v in ipairs(flashingLEDsOn) do
            electrics.values[v] = flashValue
        end
    else
        flashSwitch = false
    end
end

-- public interface
M.onInit      = onInit
M.onReset     = onReset
M.updateGFX   = updateGFX

return M
