local M = {}
M.type = "auxiliary"
M.relevantDevice = "transfercase"

local driveModesRange = nil
local driveModesSplitter = nil

local rangeBox = nil
local splitter = nil
local hasBuiltPie = false

local function updateGFX(dt)
  electrics.values.modeRangeBox = rangeBox and (rangeBox.mode == "low" and 1 or 0) or 0
  electrics.values.modeSplitter = splitter and (splitter.mode == "low" and 1 or 0) or 0
end

local function toggleRange()
  if driveModesRange then
    for _, c in ipairs(driveModesRange) do
      c.nextDriveMode()
    end
  else
    if rangeBox then
      powertrain.toggleDeviceMode(rangeBox.name)
    end
  end
end

local function setRangeMode(mode)
  if rangeBox then
    powertrain.setDeviceMode(rangeBox.name, mode)
  end
end

-- Splitter-specific functions
local function toggleSplitter()
  if driveModesSplitter then
    for _, c in ipairs(driveModesSplitter) do
      c.nextDriveMode()
    end
  else
    if splitter then
      powertrain.toggleDeviceMode(splitter.name)
    end
  end
end

local function setSplitterMode(mode)
  if splitter then
    powertrain.setDeviceMode(splitter.name, mode)
  end
end

local function serialize()
  return {
    modeRange = rangeBox and rangeBox.mode or nil,
    modeSplitter = splitter and splitter.mode or nil
  }
end

local function deserialize(data)
  if data then
    if rangeBox and data.modeRange then
      setRangeMode(data.modeRange)
    end
    if splitter and data.modeSplitter then
      setSplitterMode(data.modeSplitter)
    end
  end
end

local function init(jbeamData)
  rangeBox = powertrain.getDevice(jbeamData.rangeBoxName)
  splitter = powertrain.getDevice(jbeamData.splitterName)

  if rangeBox then
    electrics.values.modeRangeBox = rangeBox.mode == "low" and 1 or 0
  end
  if splitter then
    electrics.values.modeSplitter = splitter.mode == "low" and 1 or 0
  end

  if not hasBuiltPie then
    if rangeBox then
      core_quickAccess.addEntry(
        {
          level = "/powertrain/",
          generator = function(entries)
            local rmIcon
            if rangeBox.mode == "low" then
              rmIcon = "radial_lowrangebox"
            else
              rmIcon = "radial_highrangebox"
            end

            local rmEntry = {
              title = "ui.radialmenu2.powertrain.rangebox_mode",
              icon = rmIcon,
              onSelect = function()
                if rangeBox.mode == "low" then
                  controller.getController(M.name).setRangeMode("high")
                else
                  controller.getController(M.name).setRangeMode("low")
                end
                return {"reload"}
              end
            }
            rmEntry.color = "#ff6600"
            table.insert(entries, rmEntry)
          end
        }
      )
    end

    if splitter then
      core_quickAccess.addEntry(
        {
          level = "/powertrain/",
          generator = function(entries)
            local spIcon
            if splitter.mode == "low" then
              spIcon = "radial_lowrangebox"
            else
              spIcon = "radial_highrangebox"
            end

            local spEntry = {
              title = "ui.radialmenu2.powertrain.rangebox_mode",
              icon = spIcon,
              onSelect = function()
                if splitter.mode == "low" then
                  controller.getController(M.name).setSplitterMode("high")
                else
                  controller.getController(M.name).setSplitterMode("low")
                end
                return {"reload"}
              end
            }
            spEntry.color = "#ff6600"
            table.insert(entries, spEntry)
          end
        }
      )
    end

    hasBuiltPie = true
  end
end

local function initLastStage(jbeamData)
  local driveModesRangeNames = jbeamData.driveModesRangeNames or {}
  local driveModesSplitterNames = jbeamData.driveModesSplitterNames or {}

  driveModesRange = nil
  for _, name in ipairs(driveModesRangeNames) do
    local c = controller.getController(name)
    if c then
      driveModesRange = driveModesRange or {}
      table.insert(driveModesRange, c)
    end
  end

  driveModesSplitter = nil
  for _, name in ipairs(driveModesSplitterNames) do
    local c = controller.getController(name)
    if c then
      driveModesSplitter = driveModesSplitter or {}
      table.insert(driveModesSplitter, c)
    end
  end
end

M.init = init
M.initLastStage = initLastStage
M.updateGFX = updateGFX
M.toggleRange = toggleRange
M.setRangeMode = setRangeMode
M.toggleSplitter = toggleSplitter
M.setSplitterMode = setSplitterMode
M.serialize = serialize
M.deserialize = deserialize

return M





