local M = {}
M.type = "auxiliary"
M.relevantDevice = nil
M.defaultOrder = 1100

-- Function to toggle parking lights
function M.toggleParkLight()
    -- Toggle the park light between 0 and 1
    electrics.values.parklight = 1 - (electrics.values.parklight or 0)
end

-- Initialize function (set newlowhighbeam_toggle to 0 by default)
function M.init()
    -- Initialize the new low/high beam state
    electrics.values.newlowhighbeam_toggle = 0  -- Off by default
    lastNewLowHighBeamState = 0

    -- Initialize parklight
    electrics.values.parklight = 0  -- Off by default
end

-- Update function called every frame
function M.updateGFX(dt)
    -- Check the state of parklight
    if electrics.values.parklight == 1 then
        -- Force newlowhighbeam off when parklight is toggled to 1
        electrics.values.newlowhighbeam = 0
		electrics.values.newhighbeam = 0
		electrics.values.newlowbeam = 0
    else
        -- Mimic the state of lowhighbeam if parklight is not toggled to 1
        electrics.values.newlowhighbeam = electrics.values.lowhighbeam
		electrics.values.newhighbeam = electrics.values.highbeam
		electrics.values.newlowbeam = electrics.values.lowbeam
    end

    -- Update last state to restore when lights turn on again
    if electrics.values.lights_state ~= 0 then
        lastNewLowHighBeamState = electrics.values.newlowhighbeam
    end
end

-- Registering functions for module export
return M




