local M = {}

-- Duration in seconds for which signals will stay on initially
local SIGNAL_ON_DURATION = 2
-- Delay in seconds before starting the self-check sequence
local SELF_CHECK_DELAY = 0.2

-- Variables to track state and timing
local signalOnTimer = SELF_CHECK_DELAY  -- Start with the delay
local previousIgnitionLevel = 0
local gaugeLightsEnabled = false
local selfCheckDone = false  -- Flag to track if self-check has been done

-- Function to turn on the test signals
local function turnOnTestSignals()
    electrics.values.testsignal_L = 1
    electrics.values.testsignal_R = 1
    electrics.values.testtrailersignal_L = 1
    electrics.values.testtrailersignal_R = 1
    electrics.values.testlowbeam = 1
    electrics.values.testhighbeam = 1
    electrics.values.testlowhighbeam = 1
    electrics.values.testfog = 1
    electrics.values.testparkingbrake = 1
    electrics.values.testworklight_toggle = 1
    electrics.values.testlowAirPressure = 1
    electrics.values.testdoorajar = 1
    electrics.values.testcompressionbrake = 1
    electrics.values.testabs = 1

    -- Stuff with no function yet    
    electrics.values.testexhtemp = 1
    electrics.values.testtaglift = 1
    electrics.values.testglowplugs = 1
    electrics.values.testheightadjust = 1
    electrics.values.testdifflockRR = 1
    electrics.values.testtransfercase_lock = 1
    electrics.values.testrear_lock = 1
    electrics.values.testcrawl = 1
    electrics.values.testtacho = 1
    electrics.values.testtrailerabs = 1    
end

-- Function to mimic the behavior of signal_L and signal_R
local function mimicSignals()
    electrics.values.testsignal_L = electrics.values.signal_L
    electrics.values.testsignal_R = electrics.values.signal_R
    electrics.values.testtrailersignal_L = electrics.values.trailersignal_L
    electrics.values.testtrailersignal_R = electrics.values.trailersignal_R
    electrics.values.testlowbeam = electrics.values.newlowbeam
    electrics.values.testhighbeam = electrics.values.newhighbeam
    electrics.values.testlowhighbeam = electrics.values.newlowhighbeam
    electrics.values.testfog = electrics.values.fog
    electrics.values.testparkingbrake = electrics.values.parkingbrake
    electrics.values.testlowAirPressure = electrics.values.lowAirPressure
    electrics.values.testdoorajar = electrics.values.doorajar
    electrics.values.testcompressionbrake = electrics.values.mainEngine_compressionBrake_isEnabled
    electrics.values.testabs = electrics.values.abs	
	

    -- Custom stuff that has to revert back to 0 after mimicking the function     
    electrics.values.testworklight_toggle = electrics.values.worklight_toggle == 1
	electrics.values.testtaglift = electrics.values.AxleLiftToggle	== 1
	
    
    -- Stuff with no function to mimic yet, 0 to turn them off after self-check        
    electrics.values.testexhtemp = 0
    electrics.values.testglowplugs = 0
    electrics.values.testheightadjust = 0
    electrics.values.testdifflockRR = 0
    electrics.values.testtransfercase_lock = 0
    electrics.values.testrear_lock = 0
    electrics.values.testcrawl = 0
    electrics.values.testtacho = 0
    electrics.values.testtrailerabs = 0    
end

-- Function to toggle gauge lights
local function toggleGaugeLights(state)
    gaugeLightsEnabled = state
    electrics.values.testgaugeLights = state and 1 or 0
end

-- Initialize function
M.init = function()
    signalOnTimer = SELF_CHECK_DELAY  -- Start with the delay
    previousIgnitionLevel = electrics.values.ignitionLevel
    selfCheckDone = false
end

-- Update function (called every frame)
M.updateGFX = function(dt)
    local currentIgnitionLevel = electrics.values.ignitionLevel

    -- Add a delay before starting the self-check sequence
    if signalOnTimer > 0 then
        signalOnTimer = signalOnTimer - dt
        return  -- Delaying the self-check sequence
    end

    -- Check if the ignition level transitions to 2 and self-check hasn't been done yet
    if not selfCheckDone and previousIgnitionLevel ~= 2 and currentIgnitionLevel == 2 then
        turnOnTestSignals()
        signalOnTimer = SIGNAL_ON_DURATION
        toggleGaugeLights(true)
        selfCheckDone = true
    end

    -- Manage the timer and mimic signals after the initial period
    if signalOnTimer > 0 then
        signalOnTimer = signalOnTimer - dt
        if signalOnTimer <= 0 then
            mimicSignals()
        end
    else
        mimicSignals()  -- Ensure signals mimic when not in the initial on period
    end

    -- Reset self-check flag if ignition goes back to 0
    if currentIgnitionLevel == 0 then
        selfCheckDone = false
    end

    -- Update gauge lights state if ignition is off
    if currentIgnitionLevel ~= 2 and gaugeLightsEnabled then
        toggleGaugeLights(false)
    end

    -- Update previous ignition level
    previousIgnitionLevel = currentIgnitionLevel
end

return M









