local M = {}

local function updateGFX(dt)
    -- Check electrics values to determine the state of drlflare_R and drlflare_L
    local engineRunning = electrics.values.engineRunning

    -- Right side DRL flare logic
    local signal_R = electrics.values.signal_right_input
    if engineRunning == 1 then
        if signal_R == 0 then
            electrics.values.drlflare_R = 1  -- Turn on DRL flare for the right side
        elseif signal_R == 1 then
            electrics.values.drlflare_R = 0  -- Turn off DRL flare when signal_R is 1          
        end
    else
        electrics.values.drlflare_R = 0  -- Turn off DRL flare when engine is not running     
    end

    -- Left side DRL flare logic
    local signal_L = electrics.values.signal_left_input
    if engineRunning == 1 then
        if signal_L == 0 then
            electrics.values.drlflare_L = 1  -- Turn on DRL flare for the left side
        elseif signal_L == 1 then
            electrics.values.drlflare_L = 0  -- Turn off DRL flare when signal_L is 1          
        end
    else
        electrics.values.drlflare_L = 0  -- Turn off DRL flare when engine is not running     
    end
end

-- Public interface
M.init = function() 
    electrics.values.drlflare_R = 0  -- Ensure DRL flare for the right side is off at initialization
    electrics.values.drlflare_L = 0  -- Ensure DRL flare for the left side is off at initialization
end

M.updateGFX = updateGFX

return M




