local M = {}

-- Variable to track the previous state of the doors
local doorFLPreviousState = 0
local doorFRPreviousState = 0

-- Variables for doorajar flashing effect
local doorajarFlashing = false  -- Flag to indicate if doorajar is currently flashing
local doorajarFlashInterval = 0.3  -- Flash interval in seconds
local doorajarTimer = 0  -- Timer for doorajar flashing

-- Function to update interior light based on door state
local function updateInteriorLight()
    -- Check current door states
    local doorFLOpen = electrics.values.doorFLCoupler_notAttached == 1
    local doorFROpen = electrics.values.doorFRCoupler_notAttached == 1

    -- Check if there's a change in door state
    local doorFLChanged = doorFLOpen ~= (doorFLPreviousState == 1)
    local doorFRChanged = doorFROpen ~= (doorFRPreviousState == 1)

    -- Update interior light based on door state change
    if doorFLChanged or doorFRChanged then
        if doorFLOpen or doorFROpen then
            electrics.values.intlight = 1  -- Interior light on
            doorajarFlashing = true  -- Start flashing doorajar
            doorajarTimer = 0  -- Reset flashing timer
        else
            electrics.values.intlight = 0  -- Interior light off
            doorajarFlashing = false  -- Stop flashing doorajar
            electrics.values.doorajar = 0  -- Ensure doorajar is off when doors are closed
        end
    end

    -- Update previous door states
    doorFLPreviousState = doorFLOpen and 1 or 0
    doorFRPreviousState = doorFROpen and 1 or 0
end

-- Initialize function
M.init = function()
    -- Initialize previous door states based on current state
    doorFLPreviousState = electrics.values.doorFLCoupler_notAttached == 1 and 1 or 0
    doorFRPreviousState = electrics.values.doorFRCoupler_notAttached == 1 and 1 or 0

    -- Initialize interior light state based on initial door states
    if doorFLPreviousState == 1 or doorFRPreviousState == 1 then
        electrics.values.intlight = 1  -- Interior light on
        doorajarFlashing = true  -- Start flashing doorajar
        doorajarTimer = 0  -- Reset flashing timer
    else
        electrics.values.intlight = 0  -- Interior light off
        doorajarFlashing = false  -- Stop flashing doorajar
        electrics.values.doorajar = 0  -- Ensure doorajar is off when doors are closed
    end
end

-- Update function (called every frame)
M.updateGFX = function(dt)
    -- Check and update interior light based on door state changes
    updateInteriorLight()

    -- Handle doorajar flashing effect
    if doorajarFlashing then
        doorajarTimer = doorajarTimer + dt  -- Increment timer

        -- Toggle doorajar state based on flash interval
        if doorajarTimer >= doorajarFlashInterval then
            electrics.values.doorajar = 1 - electrics.values.doorajar  -- Toggle doorajar value
            doorajarTimer = 0  -- Reset timer
        end
    end
end

return M




