-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local engine = {}
local avToRPM = 9.549296596425384

local particleTick = 0
local particleType = 46 or 47

local previousFuel = 0
local fuelSmoother = newTemporalSmoothing(50, 50)
local tank = {
  percentOfFuelUsage = 5,
  tankSize = 112,
  tankVolumeWarn = 5,
  tankCurrentVolume = 112
}

local function createSmokeParticles()
  local engineRPM = math.abs(engine.outputAV1 * avToRPM)
  if engineRPM < 100 then
    return
  end

  for _,device in pairs(powertrain.getDevicesByType("combustionEngine")) do
    if not device.thermals or not device.thermals.exhaustEndNodes or device.thermals.coolantTemperature >= 50 then
      break
    end

    for _,n in pairs(device.thermals.exhaustEndNodes) do
      obj:addParticleByNodesRelative(n.finish, n.start, engineRPM * -0.0004 - 2, particleType, 0, 1)
    end
  end
end

local function updateTank(dt)
  -- diesel consumption
  local fuelVolume = electrics.values.fuelVolume or 0
  local fuelConsumption = math.max(0, previousFuel - fuelVolume)
  fuelConsumption = fuelSmoother:getUncapped(fuelConsumption, dt)
  previousFuel = fuelVolume

  -- additive consumption is usually about 5% of fuel consumption
  tank.tankCurrentVolume = math.min(tank.tankSize, math.max(0, tank.tankCurrentVolume - fuelConsumption*tank.percentOfFuelUsage*0.01))
  electrics.values.adGreenWarn = tank.tankCurrentVolume <= tank.tankVolumeWarn

  return tank.tankCurrentVolume > 0
end

local function updateGFX(dtSim)
  particleTick = particleTick + electrics.values.throttle

  if particleTick >= 0.75 then
    createSmokeParticles()
    particleTick = 0
  end

  -- additive tank empty
  if not updateTank(dtSim) then
    electrics.values.adGreenWarn = true
    electrics.values.adGreenEmpty = true
    engine:disable()
  end
end

local function init(jbeamData)
  engine = powertrain.getDevice("mainEngine")

  if not engine then
    M.updateGFX = nop
    return
  end

  electrics.values.adGreenWarn = false
  electrics.values.adGreenEmpty = false
  tank.percentOfFuelUsage = jbeamData.percentOfFuelUsage or tank.percentOfFuelUsage
  tank.tankSize = jbeamData.tankSize or tank.tankSize
  tank.tankVolumeWarn = jbeamData.tankVolumeWarn or tank.tankVolumeWarn
  tank.tankCurrentVolume = tank.tankSize
end

local function setTankData(input, input2)
  if type(input) == "table" then
    for k,v in pairs(input) do
      tank[k] = v
    end
  elseif type(input) == "string" and input2 then
    tank[input] = input2
  end
end

local function getTankData()
  return tank
end

M.init = init
M.updateGFX = updateGFX
M.setTankData = setTankData
M.getTankData = getTankData

return M