angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window) {
  var units = {
    uiUnitConsumptionRate: "metric",
    uiUnitDate: "ger",
    uiUnitEnergy: "metric",
    uiUnitLength: "metric",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "metric",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"
  };

  $scope.data = {};
  
  // Overwriting plain JavaScript function so we can access from within the controller
  $window.setup = (setupData) => {
    for (let dk in setupData) {
      if (typeof dk == "string" && dk.startsWith("uiUnit")) {
        units[dk] = setupData[dk];
      }
    }
    vueEventBus.emit('SettingsChanged', { values: units });
  };

  $window.updateData = (data) => {
    $scope.$evalAsync(function() {
      $scope.data.time = data.customModules.environmentData.time;

      $scope.data.speedVal = UiUnits.speed(data.electrics.wheelspeed).val.toFixed(0);
      let tempEnv = UiUnits.temperature(data.customModules.environmentData.temperatureEnv);
      if (tempEnv.val.toFixed(1) > 99.9 || tempEnv.val.toFixed(1) < -99.9) {
        $scope.data.temp = "---°C";
      } else {
        $scope.data.temp = tempEnv.val.toFixed(1) + tempEnv.unit;
      }
    });
  };

    // New functions for Zeidio integration
  $window.screenEnableZeidio = (data) => {
    $scope.$evalAsync(function() {
      // data[0]: bool, enabled
      $scope.data.zeidioEnabled = data[0];
    });
  };

  $window.zeidioPlaylistChanged = (data) => {
    $scope.$evalAsync(function() {
      // data[0]: array, all song ids in this playlist
      // data[1]: dictionary, all songdata of songs in playlist
      // data[2]: int, the id of the playlist
      $scope.data.zeidioPlaylist = data[2];
    });
  };

  $window.zeidioSongChanged = (data) => {
    $scope.$evalAsync(function() {
      // data[0]: dictionary, songdata of the current song
      $scope.data.zeidioSong = data[0];
    });
  };

  $window.zeidioPlayPauseChanged = (data) => {
    $scope.$evalAsync(function() {
      // data[0]: bool, paused
      $scope.data.zeidioPlayPause = data[0];
    });
  };

  $window.zeidioTimeChanged = (data) => {
    $scope.$evalAsync(function() {
      // data[0]: float, play time
      // data[1]: float, song duration
      $scope.data.zeidioTime = data[0];
    });
  };
});

