angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window) {
  var units = {
    uiUnitConsumptionRate: "metric",
    uiUnitDate: "ger",
    uiUnitEnergy: "metric",
    uiUnitLength: "metric",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "metric",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"
  };

  $scope.data = {};

  // Function to update data based on setupData
  $window.setup = (setupData) => {
    for (let dk in setupData) {
      if (typeof dk == "string" && dk.startsWith("uiUnit")) {
        units[dk] = setupData[dk];
      }
    }
    vueEventBus.emit('SettingsChanged', { values: units });

    $scope.data.speedUnit = units.uiUnitLength == "metric" ? "km/h" : "mph";

    if (units.uiUnitConsumptionRate == "metric") {
      $scope.data.consumptionUnit = "l/100km";
    } else {
      $scope.data.consumptionUnit = "mpg";
    }
  };

  // Function to update data based on received data
  $window.updateData = (data) => {
    $scope.$evalAsync(function() {
      // Handle gear display
	  if (data.electrics.gear === -4) {
        $scope.data.gear = "R4";
	  } else if (data.electrics.gear === -3) {
        $scope.data.gear = "R3";
	  } else if (data.electrics.gear === -2) {
        $scope.data.gear = "R2";
      } else if (data.electrics.gear === -1) {
        $scope.data.gear = "R1";
      } else if (data.electrics.gear === 0) {
        $scope.data.gear = "N";
      } else {
        $scope.data.gear = data.electrics.gear;
      }

      // Display time
      $scope.data.time = data.customModules.environmentData.time;

      // Display speed value
      $scope.data.speedVal = UiUnits.speed(data.electrics.wheelspeed).val.toFixed(0);

      // Display temperature
      let tempEnv = UiUnits.temperature(data.customModules.environmentData.temperatureEnv);
      if (tempEnv.val.toFixed(1) > 99.9 || tempEnv.val.toFixed(1) < -99.9) {
        $scope.data.temp = "---°C";
      } else {
        $scope.data.temp = tempEnv.val.toFixed(1) + tempEnv.unit;
      }

      // Display consumption rate
      let conso = UiUnits.consumptionRate(data.customModules.combustionEngineData.averageFuelConsumption * 1e-5);
      if (conso.val === "n/a") {
        $scope.data.consumptionVal = "---";
      } else {
        $scope.data.consumptionVal = conso.val.toFixed(1);
      }

      // Display odometer value
      if (data.electrics.odometer) {
        let val = data.electrics.odometer;
        val *= (units.uiUnitLength == "metric") ? 0.001 : 0.0006215;
        val = Math.min(9999999, val);
        $scope.data.odo = val.toFixed(0) + ((units.uiUnitLength == "metric") ? "" : "");
      } else {
        $scope.data.odo = "";
      }

      // Show/Hide Low Fuel Warning
      if (data.electrics.lowfuel) {
        document.getElementById("lowFuelWarning").style.display = "block";
      } else {
        document.getElementById("lowFuelWarning").style.display = "none";
      }	
	  // Show/Hide Splitter On
      if (data.electrics.splitter_state !== 1) {
	  document.getElementById("SplitterState").style.display = "none";
	  } else {
      document.getElementById("SplitterState").style.display = "block";
      }

    });
  };
});
