-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://BeamNG.com/bCDDL-1.1.txt

local M = {}

local function onInit()
  electrics.values.gear_euvan_P = 0
  electrics.values.gear_euvan_R = 0
  electrics.values.gear_euvan_N = 0
  electrics.values.gear_euvan_D = 0
  electrics.values.gear_euvan_S = 0
  electrics.values.gear_euvan_M = 0
end

local function updateGFX(dt)
  electrics.values.gear_euvan_P = (electrics.values.gear_A <= 0) or 0
  electrics.values.gear_euvan_R = (electrics.values.gear_A <= 0.1 and electrics.values.gear_A >  0.0) or 0
  electrics.values.gear_euvan_N = (electrics.values.gear_A <= 0.2 and electrics.values.gear_A >= 0.1) or 0
  electrics.values.gear_euvan_D = (electrics.values.gear_A <= 0.3 and electrics.values.gear_A >= 0.2) or 0
  electrics.values.gear_euvan_S = (electrics.values.gear_A <= 0.4 and electrics.values.gear_A >= 0.3) or 0
  electrics.values.gear_euvan_M = (electrics.values.gear_A >= 0.4) or 0
end

-- public interface
M.onInit = onInit
M.onReset = onInit
M.updateGFX = updateGFX

return M