// Written by ThatTonybo
angular.module('gaugesScreen', [])
	.filter('unsafe', function($sce) {
		return $sce.trustAsHtml;
	})
	.controller('GaugesScreenController', function($scope, $window) {
		const state = {
			speedConvertion: 3.6,
			alerts: [],
			page: 0,
			driveMode: null,
			tailgateType: 'tailgate',
			cruise: {
				enabled: false,
				speed: 0
			},
			radio: false,
			delayUpdate: null,
			headlightChime: false,
			headlightChimeInterval: undefined,
			tripTime: 0,
			tripTimeLastUpdate: null
		}

		const driveModes = {
			'COMFORT': 'Comfort',
			'OFFROAD': 'Offroad',
			'ROADSPORT': 'RoadSport',
			'ESC OFF': 'ESC & TC Off'
		}

  		$scope.data = {}

		/**
		 * Show an alert
		 * @param {string} type The type of alert: 'notification', 'warning' or 'failure'
		 * @param {string} id A unique ID to identify the alert
		 * @param {string} content The notification text content
		 * @param {string} icon An optional icon identifier
		 * @param {boolean} dismissable Set to true to show the "OK to dismiss" prompt
		 * @param {boolean} playSound Set to true to play an alert sound
		 * @param {boolean} playSoundMultiple Set to true to make the alert sound play 3 times
		 */
		const showAlert = (type, id, content, icon = null, dismissable = false, playSound = false, playSoundMultiple = false) => {
			if (state.alerts.some(x => x.id === id)) {
				const alert = state.alerts.find(x => x.id === id);

				if (alert.content === content) return;
				else {
					state.alerts[state.alerts.indexOf(alert)].content = content;

					return updateAlerts(true);
				}
			}
			
			state.alerts.push({
				type,
				id,
				content,
				icon,
				dismissable,
				playSound,
				playSoundMultiple,
				dismissed: false
			});
		
			updateAlerts();
		}

		/**
		 * Dismiss an alert (hides on screen but warning still stored)
		 * @param {string} id The alert ID to dismiss
		 */
		const dismissAlert = (id) => {
			const index = state.alerts.findIndex(x => x.id === id);
			if (index === -1) return;
			if (state.alerts[index].dismissable === false) return;
		
			state.alerts[index].dismissed = true;
		
			updateAlerts();
		}

		/**
		 * Hide an alert
		 * @param {string} id The alert ID to hide
		 */
		const hideAlert = (id) => {
			const index = state.alerts.findIndex(x => x.id === id);
			if (index === -1) return;
		
			state.alerts.splice(index, 1);
		
			updateAlerts();
		}

		/**
		 * Update the active alerts on screen
		 * @param {boolean} denySounds Set to true to not repeat sounds
		 */
		const updateAlerts = (denySounds = false) => {
			$scope.data.alert.count = state.alerts.filter(x => x.type !== 'notification').length;
		
			if (state.alerts.length === 0 || state.alerts.filter(x => !x.dismissed).length === 0) return document.getElementById('alert').style.visibility = 'hidden';
		
			const alert = state.alerts.filter(x => !x.dismissed)[state.alerts.filter(x => !x.dismissed).length - 1];
		
			$scope.data.alert.content = alert.content;
			$scope.data.alert.icon = alert.icon || 'none';
			$scope.data.alert.isDoor = ['doorDriver', 'doorPassenger', 'doorRearLeft', 'doorRearRight', 'doorHood', 'doorTailgate', 'doorRearDoors'].includes(alert.icon) ? true : false;
			$scope.data.alert.isDismissable = alert.dismissable;
		
			if (alert.type === 'notification') {
				document.getElementById('alert').classList.add('notification');
				document.getElementById('alert').classList.remove('warning');
				document.getElementById('alert').classList.remove('failure');
			}
		
			if (alert.type === 'warning') {
				document.getElementById('alert').classList.add('warning');
				document.getElementById('alert').classList.remove('notification');
				document.getElementById('alert').classList.remove('failure');
			}

			if (alert.type === 'failure') {
				document.getElementById('alert').classList.add('failure');
				document.getElementById('alert').classList.remove('notification');
				document.getElementById('alert').classList.remove('warning');
			}

			if (alert.playSound && denySounds === false) {
				beamng.sendActiveObjectLua('scoutGauges.playAlertSound()');
				
				if (alert.playSoundMultiple) {
					setTimeout(() => beamng.sendActiveObjectLua('scoutGauges.playAlertSound()'), 500);
					setTimeout(() => beamng.sendActiveObjectLua('scoutGauges.playAlertSound()'), 1000);
				}
			}
		
			document.getElementById('alert').style.visibility = 'visible';
		}

		/**
		 * Format an amount of seconds into a HH:MM:SS format
		 * @param {number} seconds The seconds to format into a duration
		 * @returns A formatted duration string
		 */
		const formatDuration = (seconds) => {
			const h = Math.floor(seconds / 3600);
			const m = Math.floor((seconds % 3600) / 60);
			const s = Math.round(seconds % 60);

			return [
				h,
				m > 9 ? m : (h ? '0' + m : m || '0'),
				s > 9 ? s : '0' + s
			].filter(Boolean).join(':');
		}

    	$window.setup = (data) => {
			$scope.data.units = {
				speed: data.uiUnitLength === 'metric' ? 'km/h' : 'mph',
				distance: data.uiUnitLength === 'metric' ? 'km' : 'mi',
				fuelConsumption: data.uiUnitLength === 'metric' ? 'L/100km' : 'mpg',
				temp: data.uiUnitTemperature.toUpperCase()
			}

			$scope.data.alert = {
				count: state.alerts.filter(x => x.type !== 'notification').length,
				content: '',
				icon: '',
				isDoor: false,
				isDismissable: false
			}
			
			$scope.data.radio = {
				exists: false,
				isPaused: false,
				name: '',
				artist: '',
				currentDuration: '',
				totalDuration: ''
			}

			state.speedConvertion = data.uiUnitLength === 'metric' ? 3.6 : 2.23694;

			setInterval(() => {
				beamng.sendActiveObjectLua('scoutGauges.getCruiseControl()');
				beamng.sendActiveObjectLua('scoutGauges.getRadio()');
			}, 500);

			beamng.sendActiveObjectLua('scoutGauges.getCruiseControl()');
			beamng.sendActiveObjectLua('scoutGauges.getRadio()');
			beamng.sendActiveObjectLua('scoutGauges.getTailgateType()');
  		}

		$window.updateData = (data) => {
			$scope.$evalAsync(() => {
				// updateData is called about 31 times average per second
				// 1000 ms / 31 = 32.2580645161 ms
				state.tripTime += 32.2580645161;

				// Data
				$scope.data.speed = (data.electrics.wheelspeed * state.speedConvertion).toFixed(0);
				$scope.data.gear = data.electrics.gear === 0 ? 'N' : (data.electrics.gear <= -1 ? 'R' : data.electrics.gear);
				$scope.data.odo = Math.floor(data.electrics.odometer / 1000).toString().padStart(6, '0');
				$scope.data.trip = (Math.floor((data.electrics.trip / 1000) * 10) / 10).toFixed(1);
				$scope.data.time = `${new Date().getHours()}:${new Date().getMinutes().toString().padStart(2, '0')}`;
				$scope.data.temp = data.customModules.environmentData.temperatureEnv.toFixed(0);
				$scope.data.fuel = (data.electrics.fuel * 100).toFixed(0);

				if (state.delayUpdate === null || (Date.now() - state.delayUpdate) >= 3000) {
					state.delayUpdate = Date.now();

					$scope.data.instFuelConsumption = data.customModules.combustionEngineData.currentFuelConsumption !== undefined
					? data.uiUnitLength === 'metric' ? data.customModules.combustionEngineData.currentFuelConsumption.toFixed(1).toString() : (235.215 / data.customModules.combustionEngineData.currentFuelConsumption).toFixed(1).toString()
					: '--.-';

					$scope.data.avgFuelConsumption = data.customModules.combustionEngineData.averageFuelConsumption !== undefined
					? data.uiUnitLength === 'metric' ? data.customModules.combustionEngineData.averageFuelConsumption.toFixed(1).toString() : (235.215 / data.customModules.combustionEngineData.averageFuelConsumption).toFixed(1).toString()
					: '--.-';

					$scope.data.dte = Math.round(data.customModules.combustionEngineData.remainingRange);
					$scope.data.tripTime = formatDuration(state.tripTime / 1000);
				}

				if (data.electrics.lowfuel === true) document.getElementById('fuel').classList.add('low');
				else document.getElementById('fuel').classList.remove('low');

				// Alerts
				//if (data.electrics.parkingbrake === 1 && (data.electrics.throttle > 0 || (data.electrics.wheelspeed * state.speedConvertion).toFixed(0) > 2) && data.electrics.engineRunning === 1)showAlert('failure', 'parkingBrake', 'Parking brake engaged', 'parkingBrake', false, true); else hideAlert('parkingBrake');

				if (data.electrics.lowfuel === true) showAlert('warning', 'lowFuel', `Low fuel level.<br />${(data.electrics.fuel * 100).toFixed(0)}% (${$scope.data.dte} ${$scope.data.units.distance}) remaining.`, 'lowFuel', true, true); else hideAlert('lowFuel');
				if (data.electrics.lowpressure > 0) showAlert('warning', 'lowTyrePressure', 'Low tyre pressure detected.', 'lowTyrePressure', true, true); else hideAlert('lowTyrePressure');
				if (data.electrics.oilPanLeak === 1) showAlert('warning', 'lowOilPressure', 'Low engine oil pressure detected.', 'lowOilPressure', true, true); else hideAlert('lowOilPressure');
				if (data.electrics.watertemp >= 105 && data.electrics.watertemp < 125) showAlert('warning', 'highWaterTemp', 'High coolant temperature detected.', 'highTemp', true, true); else hideAlert('highWaterTemp');
				if (data.electrics.watertemp >= 125) showAlert('failure', 'coolantOverheated', 'Coolant overheating.<br />Contact service.', 'extremeTemp', false, true, true); else hideAlert('coolantOverheated');
				if (data.electrics.airtemp >= 105 && data.electrics.airtemp < 125) showAlert('warning', 'highEngineTemp', 'High engine temperature detected.', 'highTemp', true, true); else hideAlert('highEngineTemp');
				if (data.electrics.airtemp >= 125) showAlert('failure', 'engineOverheated', 'Engine overheating.<br />Contact service.', 'extremeTemp', false, true, true); else hideAlert('engineOverheated');
				if (data.electrics.highBraketemp === 1) showAlert('warning', 'highBrakeTemp', 'High brake temperature detected.', 'highBrakeTemp', true, true); else hideAlert('highBrakeTemp');
				if (data.electrics.checkengine === true) showAlert('failure', 'checkEngine', 'Engine fault detected.<br />Contact service.', 'checkEngine', false, true, true); else hideAlert('checkEngine');
				if (data.electrics.fuel === 0) showAlert('failure', 'noFuel', `No fuel remaining.`, 'noFuel', false, true, true); else hideAlert('noFuel');
				
				if (data.electrics.doorLCoupler_notAttached === 1) showAlert('warning', 'driverDoorOpen', 'Left door open', 'doorDriver', true); else hideAlert('driverDoorOpen');
				if (data.electrics.doorRCoupler_notAttached === 1) showAlert('warning', 'passengerDoorOpen', 'Right door open', 'doorPassenger', true); else hideAlert('passengerDoorOpen');
				if (data.electrics.doorRLCoupler_notAttached === 1) showAlert('warning', 'rearLeftDoorOpen', 'Rear left door open', 'doorRearLeft', true); else hideAlert('rearLeftDoorOpen');
				if (data.electrics.doorRRCoupler_notAttached === 1) showAlert('warning', 'rearRightDoorOpen', 'Rear right door open', 'doorRearRight', true); else hideAlert('rearRightDoorOpen');
				if (data.electrics.hoodLatchCoupler_notAttached === 1) showAlert('warning', 'hoodOpen', 'Hood open<br />&nbsp;', 'doorHood', true); else hideAlert('hoodOpen');
				
				if (data.electrics.tailgateCoupler_notAttached === 1) {
					if (state.tailgateType === 'rearBarnDoors') showAlert('warning', 'rearDoorsOpen', `Rear door${data.electrics.tailgateRCoupler_notAttached === 1 ? 's' : ''} ajar`, 'doorRearDoors', true);
					else showAlert('warning', 'tailgateOpen', 'Tailgate open<br />&nbsp;', 'doorTailgate', true);
				} else if (data.electrics.tailgateCoupler_notAttached === 0 && data.electrics.tailgateRCoupler_notAttached === 1) {
					showAlert('warning', 'rearDoorsOpen', `Rear door open`, 'doorRearDoors', true);
				} else {
					hideAlert('tailgateOpen');
					hideAlert('rearDoorsOpen');
				}

				// Headlight Chime
				if (state.headlightChime === false && Math.round(data.electrics.ignitionLevel) === 1 && Math.round(data.electrics.lights) > 0) {
					state.headlightChime = true;
					state.headlightChimeInterval = setInterval(() => beamng.sendActiveObjectLua('scoutGauges.playAlertSound()'), 1000);
				}

				if (
					state.headlightChime === true && Math.round(data.electrics.ignitionLevel) === 1 && Math.round(data.electrics.lights) === 0
					|| state.headlightChime === true && Math.round(data.electrics.ignitionLevel) === 0
					|| state.headlightChime === true && Math.round(data.electrics.ignitionLevel) === 2
				) {
					clearInterval(state.headlightChimeInterval);

					state.headlightChime = false;
					state.headlightChimeInterval = undefined;
				}
			});
		}

		$window.updateMode = (data) => {
			if (state.driveMode !== null && data.modeName !== state.driveMode) {
				showAlert('notification', 'driveMode', `Drive mode changed to<br />${driveModes[data.modeName] || '???'}`, 'driveMode');

				setTimeout(() => hideAlert('driveMode'), 2500);
			}

			state.driveMode = data.modeName;

			switch (state.driveMode) {
				case 'COMFORT':
					document.getElementById('gauge').classList.remove('Offroad');
					document.getElementById('gauge').classList.remove('RS');
				break;

				case 'OFFROAD':
					document.getElementById('gauge').classList.add('Offroad');
					document.getElementById('gauge').classList.remove('RS');
				break;

				case 'ROADSPORT':
					document.getElementById('gauge').classList.add('RS');
					document.getElementById('gauge').classList.remove('Offroad');
				break;

				case 'ESC OFF':
					document.getElementById('gauge').classList.remove('Offroad');
					document.getElementById('gauge').classList.remove('RS');
				break;
			}
		}

		$window.setupTailgateType = (type) => state.tailgateType = type || 'tailgate';

		$window.cruiseControlUpdate = (data) => {
			if (data.isEnabled === true && state.cruise.enabled === false) {
				state.cruise.enabled = data.isEnabled;

				showAlert('notification', 'cruise', `Cruise control set to<br />${(data.targetSpeed * state.speedConvertion).toFixed(0)} ${$scope.data.units.speed}`, 'cruise');

				setTimeout(() => hideAlert('cruise'), 2500)
			} else if (data.isEnabled === false && state.cruise.enabled === true) {
				state.cruise.enabled = data.isEnabled;

				hideAlert('cruise');
			} else state.cruise.enabled = data.isEnabled;
		}

		$window.radioUpdate = (data) => {
			if (state.radio === false) state.radio = true;

			if (data.songsInPlaylist === 1) return $scope.data.radio.artist = 'No media available';

			const name = data.name === 'empty' ? '' : data.name;
			const artist = data.artist === 'empty' ? 'No media playing' : data.artist;

			$scope.data.radio.exists = state.radio;
			$scope.data.radio.isPaused = data.isPaused;
			$scope.data.radio.name = name.length > 27 ? `${name.slice(0, 24)}...` : name;
			$scope.data.radio.artist = artist.length > 27 ? `${artist.slice(0, 24)}...` : artist;
			$scope.data.radio.currentDuration = formatDuration(data.timeSinceStart);
			$scope.data.radio.totalDuration = formatDuration(data.duration);
		}

		$window.changeDynamicContent = () => {
			beamng.sendActiveObjectLua('scoutGauges.playButtonSound()');

			if (state.page === 3) state.page = 0; else state.page += 1;

			switch (state.page) {
				case 0:
					document.getElementById('page_0').classList.add('active');
					document.getElementById('page_1').classList.remove('active');
					document.getElementById('page_2').classList.remove('active');
					document.getElementById('page_3').classList.remove('active');
				break;

				case 1:
					document.getElementById('page_1').classList.add('active');
					document.getElementById('page_0').classList.remove('active');
					document.getElementById('page_2').classList.remove('active');
					document.getElementById('page_3').classList.remove('active');
				break;

				case 2:
					document.getElementById('page_2').classList.add('active');
					document.getElementById('page_0').classList.remove('active');
					document.getElementById('page_1').classList.remove('active');
					document.getElementById('page_3').classList.remove('active');
				break;

				case 3:
					document.getElementById('page_3').classList.add('active');
					document.getElementById('page_0').classList.remove('active');
					document.getElementById('page_1').classList.remove('active');
					document.getElementById('page_2').classList.remove('active');
				break;
			}
		}

		$window.dismissActiveAlert = () => {
			if (!state.alerts.filter(x => x.dismissable === true && !x.dismissed).length) return;

			beamng.sendActiveObjectLua('scoutGauges.playButtonSound()');

			const alert = state.alerts.filter(x => x.dismissable === true && !x.dismissed)[state.alerts.filter(x => x.dismissable === true && !x.dismissed).length - 1];

			dismissAlert(alert.id);
		}
	}
);    
