-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onInit()
 electrics.values.vwSpeedo60 = 0
 electrics.values.vwSpeedo220 = 0
 electrics.values.vwSpeedo280 = 0
 electrics.values.vwSpeedo = 0
end

local function updateGFX(dt)
electrics.values.vwSpeedo60 = electrics.values.wheelspeed
electrics.values.vwSpeedo220 = 8.3295 + (electrics.values.wheelspeed / 2)
electrics.values.vwSpeedo280 = 18.5 + (electrics.values.wheelspeed / 3)
 if electrics.values.wheelspeed < 16.66 then 
    electrics.values.vwSpeedo = electrics.values.vwSpeedo60  
 elseif electrics.values.wheelspeed >= 16.66 and electrics.values.wheelspeed < 61.11 then 
    electrics.values.vwSpeedo = electrics.values.vwSpeedo220  
 elseif electrics.values.wheelspeed >= 61.11 then
    electrics.values.vwSpeedo = electrics.values.vwSpeedo280
 end	

end

-- public interface

M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M
