-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onInit()
 electrics.values.vwRSpeedo120 = 0
 electrics.values.vwRSpeedo240 = 0
 electrics.values.vwRSpeedo300 = 0
 electrics.values.vwRSpeedo = 0
end

local function updateGFX(dt)
electrics.values.vwRSpeedo120 = electrics.values.wheelspeed
electrics.values.vwRSpeedo240 = 13.7 + (electrics.values.wheelspeed / 1.7)
electrics.values.vwRSpeedo300 = 29.2 + (electrics.values.wheelspeed / 2.8)
 if electrics.values.wheelspeed < 33.33 then 
    electrics.values.vwRSpeedo = electrics.values.vwRSpeedo120  
 elseif electrics.values.wheelspeed >= 33.33 and electrics.values.wheelspeed < 66.66 then 
    electrics.values.vwRSpeedo = electrics.values.vwRSpeedo240  
 elseif electrics.values.wheelspeed >= 66.66 then
    electrics.values.vwRSpeedo = electrics.values.vwRSpeedo300
 end	

end

-- public interface

M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M
